/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnAdminState;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvAdminState;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnAdminStateSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvAdminStateVer13
implements OFBsnTlvAdminState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvAdminStateVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private final OFBsnAdminState value;
    static final Reader READER = new Reader();
    static final OFBsnTlvAdminStateVer13Funnel FUNNEL = new OFBsnTlvAdminStateVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvAdminStateVer13(OFBsnAdminState value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvAdminStateVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 216;
    }

    @Override
    public OFBsnAdminState getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvAdminState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvAdminStateVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvAdminStateVer13 other = (OFBsnTlvAdminStateVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvAdminStateVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvAdminStateVer13 message) {
            bb.writeShort(216);
            bb.writeShort(5);
            OFBsnAdminStateSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvAdminStateVer13Funnel
    implements Funnel<OFBsnTlvAdminStateVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvAdminStateVer13Funnel() {
        }

        public void funnel(OFBsnTlvAdminStateVer13 message, PrimitiveSink sink) {
            sink.putShort((short)216);
            sink.putShort((short)5);
            OFBsnAdminStateSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvAdminState> {
        Reader() {
        }

        @Override
        public OFBsnTlvAdminState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 216) {
                throw new OFParseError("Wrong type: Expected=0xd8(0xd8), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnAdminState value = OFBsnAdminStateSerializerVer13.readFrom(bb);
            OFBsnTlvAdminStateVer13 bsnTlvAdminStateVer13 = new OFBsnTlvAdminStateVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvAdminStateVer13);
            }
            return bsnTlvAdminStateVer13;
        }
    }

    static class Builder
    implements OFBsnTlvAdminState.Builder {
        private boolean valueSet;
        private OFBsnAdminState value;

        Builder() {
        }

        @Override
        public int getType() {
            return 216;
        }

        @Override
        public OFBsnAdminState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAdminState.Builder setValue(OFBsnAdminState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvAdminState build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAdminStateVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvAdminState.Builder {
        final OFBsnTlvAdminStateVer13 parentMessage;
        private boolean valueSet;
        private OFBsnAdminState value;

        BuilderWithParent(OFBsnTlvAdminStateVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 216;
        }

        @Override
        public OFBsnAdminState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAdminState.Builder setValue(OFBsnAdminState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvAdminState build() {
            OFBsnAdminState value;
            OFBsnAdminState oFBsnAdminState = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAdminStateVer13(value);
        }
    }
}

