/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnActionState;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvActionState;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnActionStateSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvActionStateVer13
implements OFBsnTlvActionState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvActionStateVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnActionState value;
    static final Reader READER = new Reader();
    static final OFBsnTlvActionStateVer13Funnel FUNNEL = new OFBsnTlvActionStateVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvActionStateVer13(OFBsnActionState value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvActionStateVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 226;
    }

    @Override
    public OFBsnActionState getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvActionState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvActionStateVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvActionStateVer13 other = (OFBsnTlvActionStateVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvActionStateVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvActionStateVer13 message) {
            bb.writeShort(226);
            bb.writeShort(6);
            OFBsnActionStateSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvActionStateVer13Funnel
    implements Funnel<OFBsnTlvActionStateVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvActionStateVer13Funnel() {
        }

        public void funnel(OFBsnTlvActionStateVer13 message, PrimitiveSink sink) {
            sink.putShort((short)226);
            sink.putShort((short)6);
            OFBsnActionStateSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvActionState> {
        Reader() {
        }

        @Override
        public OFBsnTlvActionState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 226) {
                throw new OFParseError("Wrong type: Expected=0xe2(0xe2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnActionState value = OFBsnActionStateSerializerVer13.readFrom(bb);
            OFBsnTlvActionStateVer13 bsnTlvActionStateVer13 = new OFBsnTlvActionStateVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvActionStateVer13);
            }
            return bsnTlvActionStateVer13;
        }
    }

    static class Builder
    implements OFBsnTlvActionState.Builder {
        private boolean valueSet;
        private OFBsnActionState value;

        Builder() {
        }

        @Override
        public int getType() {
            return 226;
        }

        @Override
        public OFBsnActionState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActionState.Builder setValue(OFBsnActionState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvActionState build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvActionStateVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvActionState.Builder {
        final OFBsnTlvActionStateVer13 parentMessage;
        private boolean valueSet;
        private OFBsnActionState value;

        BuilderWithParent(OFBsnTlvActionStateVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 226;
        }

        @Override
        public OFBsnActionState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActionState.Builder setValue(OFBsnActionState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvActionState build() {
            OFBsnActionState value;
            OFBsnActionState oFBsnActionState = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvActionStateVer13(value);
        }
    }
}

