/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigProp;
import org.projectfloodlight.openflow.protocol.OFAsyncGetRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncGetRequestVer13
implements OFAsyncGetRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncGetRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFAsyncGetRequestVer13 DEFAULT = new OFAsyncGetRequestVer13(0L);
    static final Reader READER = new Reader();
    static final OFAsyncGetRequestVer13Funnel FUNNEL = new OFAsyncGetRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncGetRequestVer13(long xid) {
        this.xid = U32.normalize(xid);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.GET_ASYNC_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public List<OFAsyncConfigProp> getProperties() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property properties not supported in version 1.3");
    }

    @Override
    public OFAsyncGetRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncGetRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncGetRequestVer13 other = (OFAsyncGetRequestVer13)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncGetRequestVer13 other = (OFAsyncGetRequestVer13)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncGetRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncGetRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(26);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.xid));
        }
    }

    static class OFAsyncGetRequestVer13Funnel
    implements Funnel<OFAsyncGetRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFAsyncGetRequestVer13Funnel() {
        }

        public void funnel(OFAsyncGetRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)26);
            sink.putShort((short)8);
            sink.putLong(message.xid);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncGetRequest> {
        Reader() {
        }

        @Override
        public OFAsyncGetRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 26) {
                throw new OFParseError("Wrong type: Expected=OFType.GET_ASYNC_REQUEST(26), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFAsyncGetRequestVer13 asyncGetRequestVer13 = new OFAsyncGetRequestVer13(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncGetRequestVer13);
            }
            return asyncGetRequestVer13;
        }
    }

    static class Builder
    implements OFAsyncGetRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.GET_ASYNC_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public List<OFAsyncConfigProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFAsyncGetRequest.Builder setProperties(List<OFAsyncConfigProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFAsyncGetRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFAsyncGetRequestVer13(xid);
        }
    }

    static class BuilderWithParent
    implements OFAsyncGetRequest.Builder {
        final OFAsyncGetRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFAsyncGetRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.GET_ASYNC_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public List<OFAsyncConfigProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFAsyncGetRequest.Builder setProperties(List<OFAsyncConfigProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFAsyncGetRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFAsyncGetRequestVer13(xid);
        }
    }
}

