/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdSetMplsTtl;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdSetMplsTtlVer13
implements OFActionIdSetMplsTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdSetMplsTtlVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 4;
    static final OFActionIdSetMplsTtlVer13 DEFAULT = new OFActionIdSetMplsTtlVer13();
    static final OFActionIdSetMplsTtlVer13 INSTANCE = new OFActionIdSetMplsTtlVer13();
    static final Reader READER = new Reader();
    static final OFActionIdSetMplsTtlVer13Funnel FUNNEL = new OFActionIdSetMplsTtlVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdSetMplsTtlVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_MPLS_TTL;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionIdSetMplsTtl.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdSetMplsTtlVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdSetMplsTtlVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdSetMplsTtlVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdSetMplsTtlVer13 message) {
            bb.writeShort(15);
            bb.writeShort(4);
        }
    }

    static class OFActionIdSetMplsTtlVer13Funnel
    implements Funnel<OFActionIdSetMplsTtlVer13> {
        private static final long serialVersionUID = 1L;

        OFActionIdSetMplsTtlVer13Funnel() {
        }

        public void funnel(OFActionIdSetMplsTtlVer13 message, PrimitiveSink sink) {
            sink.putShort((short)15);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdSetMplsTtl> {
        Reader() {
        }

        @Override
        public OFActionIdSetMplsTtl readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 15) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_MPLS_TTL(15), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

