/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionCopyTtlIn;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionCopyTtlInVer13
implements OFActionCopyTtlIn {
    private static final Logger logger = LoggerFactory.getLogger(OFActionCopyTtlInVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    static final OFActionCopyTtlInVer13 DEFAULT = new OFActionCopyTtlInVer13();
    static final OFActionCopyTtlInVer13 INSTANCE = new OFActionCopyTtlInVer13();
    static final Reader READER = new Reader();
    static final OFActionCopyTtlInVer13Funnel FUNNEL = new OFActionCopyTtlInVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionCopyTtlInVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.COPY_TTL_IN;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionCopyTtlIn.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionCopyTtlInVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionCopyTtlInVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionCopyTtlInVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionCopyTtlInVer13 message) {
            bb.writeShort(12);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionCopyTtlInVer13Funnel
    implements Funnel<OFActionCopyTtlInVer13> {
        private static final long serialVersionUID = 1L;

        OFActionCopyTtlInVer13Funnel() {
        }

        public void funnel(OFActionCopyTtlInVer13 message, PrimitiveSink sink) {
            sink.putShort((short)12);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionCopyTtlIn> {
        Reader() {
        }

        @Override
        public OFActionCopyTtlIn readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 12) {
                throw new OFParseError("Wrong type: Expected=OFActionType.COPY_TTL_IN(12), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

