/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionBsnSetTunnelDst;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionBsnSetTunnelDstVer13
implements OFActionBsnSetTunnelDst {
    private static final Logger logger = LoggerFactory.getLogger(OFActionBsnSetTunnelDstVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final long DEFAULT_DST = 0L;
    private final long dst;
    static final OFActionBsnSetTunnelDstVer13 DEFAULT = new OFActionBsnSetTunnelDstVer13(0L);
    static final Reader READER = new Reader();
    static final OFActionBsnSetTunnelDstVer13Funnel FUNNEL = new OFActionBsnSetTunnelDstVer13Funnel();
    static final Writer WRITER = new Writer();

    OFActionBsnSetTunnelDstVer13(long dst) {
        this.dst = U32.normalize(dst);
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 2L;
    }

    @Override
    public long getDst() {
        return this.dst;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionBsnSetTunnelDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionBsnSetTunnelDstVer13(");
        b.append("dst=").append(this.dst);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionBsnSetTunnelDstVer13 other = (OFActionBsnSetTunnelDstVer13)obj;
        return this.dst == other.dst;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.dst ^ this.dst >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionBsnSetTunnelDstVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionBsnSetTunnelDstVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(6035143);
            bb.writeInt(2);
            bb.writeInt(U32.t(message.dst));
        }
    }

    static class OFActionBsnSetTunnelDstVer13Funnel
    implements Funnel<OFActionBsnSetTunnelDstVer13> {
        private static final long serialVersionUID = 1L;

        OFActionBsnSetTunnelDstVer13Funnel() {
        }

        public void funnel(OFActionBsnSetTunnelDstVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(6035143);
            sink.putInt(2);
            sink.putLong(message.dst);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionBsnSetTunnelDst> {
        Reader() {
        }

        @Override
        public OFActionBsnSetTunnelDst readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 2) {
                throw new OFParseError("Wrong subtype: Expected=0x2L(0x2L), got=" + subtype);
            }
            long dst = U32.f(bb.readInt());
            OFActionBsnSetTunnelDstVer13 actionBsnSetTunnelDstVer13 = new OFActionBsnSetTunnelDstVer13(dst);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionBsnSetTunnelDstVer13);
            }
            return actionBsnSetTunnelDstVer13;
        }
    }

    static class Builder
    implements OFActionBsnSetTunnelDst.Builder {
        private boolean dstSet;
        private long dst;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 2L;
        }

        @Override
        public long getDst() {
            return this.dst;
        }

        @Override
        public OFActionBsnSetTunnelDst.Builder setDst(long dst) {
            this.dst = dst;
            this.dstSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionBsnSetTunnelDst build() {
            long dst = this.dstSet ? this.dst : 0L;
            return new OFActionBsnSetTunnelDstVer13(dst);
        }
    }

    static class BuilderWithParent
    implements OFActionBsnSetTunnelDst.Builder {
        final OFActionBsnSetTunnelDstVer13 parentMessage;
        private boolean dstSet;
        private long dst;

        BuilderWithParent(OFActionBsnSetTunnelDstVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 2L;
        }

        @Override
        public long getDst() {
            return this.dst;
        }

        @Override
        public OFActionBsnSetTunnelDst.Builder setDst(long dst) {
            this.dst = dst;
            this.dstSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionBsnSetTunnelDst build() {
            long dst = this.dstSet ? this.dst : this.parentMessage.dst;
            return new OFActionBsnSetTunnelDstVer13(dst);
        }
    }
}

