/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableMod;
import org.projectfloodlight.openflow.protocol.OFTableModProp;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableModVer12
implements OFTableMod {
    private static final Logger logger = LoggerFactory.getLogger(OFTableModVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final long DEFAULT_CONFIG = 0L;
    private final long xid;
    private final TableId tableId;
    private final long config;
    static final OFTableModVer12 DEFAULT = new OFTableModVer12(0L, DEFAULT_TABLE_ID, 0L);
    static final Reader READER = new Reader();
    static final OFTableModVer12Funnel FUNNEL = new OFTableModVer12Funnel();
    static final Writer WRITER = new Writer();

    OFTableModVer12(long xid, TableId tableId, long config) {
        if (tableId == null) {
            throw new NullPointerException("OFTableModVer12: property tableId cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.tableId = tableId;
        this.config = U32.normalize(config);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.TABLE_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getConfig() {
        return this.config;
    }

    @Override
    public List<OFTableModProp> getProperties() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property properties not supported in version 1.2");
    }

    @Override
    public OFTableMod.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableModVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableModVer12 other = (OFTableModVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return this.config == other.config;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableModVer12 other = (OFTableModVer12)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return this.config == other.config;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.config ^ this.config >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.config ^ this.config >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableModVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableModVer12 message) {
            bb.writeByte(3);
            bb.writeByte(17);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            message.tableId.writeByte(bb);
            bb.writeZero(3);
            bb.writeInt(U32.t(message.config));
        }
    }

    static class OFTableModVer12Funnel
    implements Funnel<OFTableModVer12> {
        private static final long serialVersionUID = 1L;

        OFTableModVer12Funnel() {
        }

        public void funnel(OFTableModVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)17);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            message.tableId.putTo(sink);
            sink.putLong(message.config);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableMod> {
        Reader() {
        }

        @Override
        public OFTableMod readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 17) {
                throw new OFParseError("Wrong type: Expected=OFType.TABLE_MOD(17), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(3);
            long config = U32.f(bb.readInt());
            OFTableModVer12 tableModVer12 = new OFTableModVer12(xid, tableId, config);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableModVer12);
            }
            return tableModVer12;
        }
    }

    static class Builder
    implements OFTableMod.Builder {
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean configSet;
        private long config;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.TABLE_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableMod.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFTableMod.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public List<OFTableModProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.2");
        }

        @Override
        public OFTableMod.Builder setProperties(List<OFTableModProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.2");
        }

        @Override
        public OFTableMod build() {
            TableId tableId;
            long xid = this.xidSet ? this.xid : 0L;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long config = this.configSet ? this.config : 0L;
            return new OFTableModVer12(xid, tableId, config);
        }
    }

    static class BuilderWithParent
    implements OFTableMod.Builder {
        final OFTableModVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean configSet;
        private long config;

        BuilderWithParent(OFTableModVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.TABLE_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableMod.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFTableMod.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public List<OFTableModProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.2");
        }

        @Override
        public OFTableMod.Builder setProperties(List<OFTableModProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.2");
        }

        @Override
        public OFTableMod build() {
            TableId tableId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long config = this.configSet ? this.config : this.parentMessage.config;
            return new OFTableModVer12(xid, tableId, config);
        }
    }
}

