/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingTpDstMasked;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmConnTrackingTpDstVer12;
import org.projectfloodlight.openflow.types.TransportPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingTpDstMaskedVer12
implements OFOxmConnTrackingTpDstMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingTpDstMaskedVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 8;
    private static final TransportPort DEFAULT_VALUE = TransportPort.NONE;
    private static final TransportPort DEFAULT_VALUE_MASK = TransportPort.NONE;
    private final TransportPort value;
    private final TransportPort mask;
    static final OFOxmConnTrackingTpDstMaskedVer12 DEFAULT = new OFOxmConnTrackingTpDstMaskedVer12(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingTpDstMaskedVer12Funnel FUNNEL = new OFOxmConnTrackingTpDstMaskedVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingTpDstMaskedVer12(TransportPort value, TransportPort mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingTpDstMaskedVer12: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmConnTrackingTpDstMaskedVer12: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 129796L;
    }

    @Override
    public TransportPort getValue() {
        return this.value;
    }

    @Override
    public TransportPort getMask() {
        return this.mask;
    }

    @Override
    public MatchField<TransportPort> getMatchField() {
        return MatchField.CONN_TRACKING_TP_DST;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<TransportPort> getCanonical() {
        if (TransportPort.NO_MASK.equals(this.mask)) {
            return new OFOxmConnTrackingTpDstVer12(this.value);
        }
        if (TransportPort.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmConnTrackingTpDstMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingTpDstMaskedVer12(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingTpDstMaskedVer12 other = (OFOxmConnTrackingTpDstMaskedVer12)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingTpDstMaskedVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingTpDstMaskedVer12 message) {
            bb.writeInt(129796);
            message.value.write2Bytes(bb);
            message.mask.write2Bytes(bb);
        }
    }

    static class OFOxmConnTrackingTpDstMaskedVer12Funnel
    implements Funnel<OFOxmConnTrackingTpDstMaskedVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingTpDstMaskedVer12Funnel() {
        }

        public void funnel(OFOxmConnTrackingTpDstMaskedVer12 message, PrimitiveSink sink) {
            sink.putInt(129796);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingTpDstMasked> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingTpDstMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 129796) {
                throw new OFParseError("Wrong typeLen: Expected=0x1fb04L(0x1fb04L), got=" + typeLen);
            }
            TransportPort value = TransportPort.read2Bytes(bb);
            TransportPort mask = TransportPort.read2Bytes(bb);
            OFOxmConnTrackingTpDstMaskedVer12 oxmConnTrackingTpDstMaskedVer12 = new OFOxmConnTrackingTpDstMaskedVer12(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingTpDstMaskedVer12);
            }
            return oxmConnTrackingTpDstMaskedVer12;
        }
    }

    static class Builder
    implements OFOxmConnTrackingTpDstMasked.Builder {
        private boolean valueSet;
        private TransportPort value;
        private boolean maskSet;
        private TransportPort mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 129796L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingTpDstMasked.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public TransportPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingTpDstMasked.Builder setMask(TransportPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.CONN_TRACKING_TP_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmConnTrackingTpDstMasked build() {
            TransportPort mask;
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            TransportPort transportPort2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingTpDstMaskedVer12(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingTpDstMasked.Builder {
        final OFOxmConnTrackingTpDstMaskedVer12 parentMessage;
        private boolean valueSet;
        private TransportPort value;
        private boolean maskSet;
        private TransportPort mask;

        BuilderWithParent(OFOxmConnTrackingTpDstMaskedVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 129796L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingTpDstMasked.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public TransportPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingTpDstMasked.Builder setMask(TransportPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.CONN_TRACKING_TP_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmConnTrackingTpDstMasked build() {
            TransportPort mask;
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            TransportPort transportPort2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingTpDstMaskedVer12(value, mask);
        }
    }
}

