/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver12.OFBadActionErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBadInstructionErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBadMatchErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBadRequestErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFExperimenterErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFFlowModFailedErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupModFailedErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFHelloFailedErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFPortModFailedErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFQueueOpFailedErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFRoleRequestFailedErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFSwitchConfigFailedErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFTableModFailedErrorMsgVer12;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFErrorMsgVer12 {
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 10;
    public static final Reader READER = new Reader();

    OFErrorMsgVer12() {
    }

    static class Reader
    implements OFMessageReader<OFErrorMsg> {
        Reader() {
        }

        @Override
        public OFErrorMsg readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 10) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 10) {
                throw new OFParseError("Wrong length: Expected to be >= 10, was: " + length);
            }
            U32.f(bb.readInt());
            short errType = bb.readShort();
            bb.readerIndex(start);
            switch (errType) {
                case 2: {
                    return OFBadActionErrorMsgVer12.READER.readFrom(bb);
                }
                case 1: {
                    return OFBadRequestErrorMsgVer12.READER.readFrom(bb);
                }
                case 5: {
                    return OFFlowModFailedErrorMsgVer12.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloFailedErrorMsgVer12.READER.readFrom(bb);
                }
                case 7: {
                    return OFPortModFailedErrorMsgVer12.READER.readFrom(bb);
                }
                case 9: {
                    return OFQueueOpFailedErrorMsgVer12.READER.readFrom(bb);
                }
                case 3: {
                    return OFBadInstructionErrorMsgVer12.READER.readFrom(bb);
                }
                case 4: {
                    return OFBadMatchErrorMsgVer12.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupModFailedErrorMsgVer12.READER.readFrom(bb);
                }
                case 10: {
                    return OFSwitchConfigFailedErrorMsgVer12.READER.readFrom(bb);
                }
                case 8: {
                    return OFTableModFailedErrorMsgVer12.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterErrorMsgVer12.READER.readFrom(bb);
                }
                case 11: {
                    return OFRoleRequestFailedErrorMsgVer12.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator errType of class OFErrorMsgVer12: " + errType);
        }
    }
}

