/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSetPktinSuppressionRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnSetPktinSuppressionRequestVer12
implements OFBsnSetPktinSuppressionRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSetPktinSuppressionRequestVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 32;
    private static final long DEFAULT_XID = 0L;
    private static final boolean DEFAULT_ENABLED = false;
    private static final int DEFAULT_IDLE_TIMEOUT = 0;
    private static final int DEFAULT_HARD_TIMEOUT = 0;
    private static final int DEFAULT_PRIORITY = 0;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private final long xid;
    private final boolean enabled;
    private final int idleTimeout;
    private final int hardTimeout;
    private final int priority;
    private final U64 cookie;
    static final OFBsnSetPktinSuppressionRequestVer12 DEFAULT = new OFBsnSetPktinSuppressionRequestVer12(0L, false, 0, 0, 0, DEFAULT_COOKIE);
    static final Reader READER = new Reader();
    static final OFBsnSetPktinSuppressionRequestVer12Funnel FUNNEL = new OFBsnSetPktinSuppressionRequestVer12Funnel();
    static final Writer WRITER = new Writer();

    OFBsnSetPktinSuppressionRequestVer12(long xid, boolean enabled, int idleTimeout, int hardTimeout, int priority, U64 cookie) {
        if (cookie == null) {
            throw new NullPointerException("OFBsnSetPktinSuppressionRequestVer12: property cookie cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.enabled = enabled;
        this.idleTimeout = U16.normalize(idleTimeout);
        this.hardTimeout = U16.normalize(hardTimeout);
        this.priority = U16.normalize(priority);
        this.cookie = cookie;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 11L;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getHardTimeout() {
        return this.hardTimeout;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public OFBsnSetPktinSuppressionRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSetPktinSuppressionRequestVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("enabled=").append(this.enabled);
        b.append(", ");
        b.append("idleTimeout=").append(this.idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(this.hardTimeout);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetPktinSuppressionRequestVer12 other = (OFBsnSetPktinSuppressionRequestVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return !(this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetPktinSuppressionRequestVer12 other = (OFBsnSetPktinSuppressionRequestVer12)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return !(this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + this.priority;
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + this.priority;
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnSetPktinSuppressionRequestVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnSetPktinSuppressionRequestVer12 message) {
            bb.writeByte(3);
            bb.writeByte(4);
            bb.writeShort(32);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(11);
            bb.writeByte(message.enabled ? 1 : 0);
            bb.writeZero(1);
            bb.writeShort((int)U16.t(message.idleTimeout));
            bb.writeShort((int)U16.t(message.hardTimeout));
            bb.writeShort((int)U16.t(message.priority));
            bb.writeLong(message.cookie.getValue());
        }
    }

    static class OFBsnSetPktinSuppressionRequestVer12Funnel
    implements Funnel<OFBsnSetPktinSuppressionRequestVer12> {
        private static final long serialVersionUID = 1L;

        OFBsnSetPktinSuppressionRequestVer12Funnel() {
        }

        public void funnel(OFBsnSetPktinSuppressionRequestVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)4);
            sink.putShort((short)32);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(11);
            sink.putBoolean(message.enabled);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            sink.putInt(message.priority);
            message.cookie.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnSetPktinSuppressionRequest> {
        Reader() {
        }

        @Override
        public OFBsnSetPktinSuppressionRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 32) {
                throw new OFParseError("Wrong length: Expected=32(32), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 11) {
                throw new OFParseError("Wrong subtype: Expected=0xbL(0xbL), got=" + subtype);
            }
            boolean enabled = bb.readByte() != 0;
            bb.skipBytes(1);
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            int priority = U16.f(bb.readShort());
            U64 cookie = U64.ofRaw(bb.readLong());
            OFBsnSetPktinSuppressionRequestVer12 bsnSetPktinSuppressionRequestVer12 = new OFBsnSetPktinSuppressionRequestVer12(xid, enabled, idleTimeout, hardTimeout, priority, cookie);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnSetPktinSuppressionRequestVer12);
            }
            return bsnSetPktinSuppressionRequestVer12;
        }
    }

    static class Builder
    implements OFBsnSetPktinSuppressionRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean enabledSet;
        private boolean enabled;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean prioritySet;
        private int priority;
        private boolean cookieSet;
        private U64 cookie;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 11L;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest build() {
            U64 cookie;
            long xid = this.xidSet ? this.xid : 0L;
            boolean enabled = this.enabledSet ? this.enabled : false;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : 0;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : 0;
            int priority = this.prioritySet ? this.priority : 0;
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            return new OFBsnSetPktinSuppressionRequestVer12(xid, enabled, idleTimeout, hardTimeout, priority, cookie);
        }
    }

    static class BuilderWithParent
    implements OFBsnSetPktinSuppressionRequest.Builder {
        final OFBsnSetPktinSuppressionRequestVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean enabledSet;
        private boolean enabled;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean prioritySet;
        private int priority;
        private boolean cookieSet;
        private U64 cookie;

        BuilderWithParent(OFBsnSetPktinSuppressionRequestVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 11L;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public OFBsnSetPktinSuppressionRequest build() {
            U64 cookie;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            boolean enabled = this.enabledSet ? this.enabled : this.parentMessage.enabled;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : this.parentMessage.idleTimeout;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : this.parentMessage.hardTimeout;
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            return new OFBsnSetPktinSuppressionRequestVer12(xid, enabled, idleTimeout, hardTimeout, priority, cookie);
        }
    }
}

