/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGetInterfacesReply;
import org.projectfloodlight.openflow.protocol.OFBsnInterface;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnInterfaceVer12;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGetInterfacesReplyVer12
implements OFBsnGetInterfacesReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGetInterfacesReplyVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 16;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final List<OFBsnInterface> DEFAULT_INTERFACES = ImmutableList.of();
    private final long xid;
    private final List<OFBsnInterface> interfaces;
    static final OFBsnGetInterfacesReplyVer12 DEFAULT = new OFBsnGetInterfacesReplyVer12(0L, DEFAULT_INTERFACES);
    static final Reader READER = new Reader();
    static final OFBsnGetInterfacesReplyVer12Funnel FUNNEL = new OFBsnGetInterfacesReplyVer12Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGetInterfacesReplyVer12(long xid, List<OFBsnInterface> interfaces) {
        if (interfaces == null) {
            throw new NullPointerException("OFBsnGetInterfacesReplyVer12: property interfaces cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.interfaces = interfaces;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 10L;
    }

    @Override
    public List<OFBsnInterface> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public OFBsnGetInterfacesReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGetInterfacesReplyVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("interfaces=").append(this.interfaces);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetInterfacesReplyVer12 other = (OFBsnGetInterfacesReplyVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.interfaces == null ? other.interfaces != null : !this.interfaces.equals(other.interfaces));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetInterfacesReplyVer12 other = (OFBsnGetInterfacesReplyVer12)obj;
        return !(this.interfaces == null ? other.interfaces != null : !this.interfaces.equals(other.interfaces));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.interfaces == null ? 0 : this.interfaces.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interfaces == null ? 0 : this.interfaces.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGetInterfacesReplyVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGetInterfacesReplyVer12 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(3);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(10);
            ChannelUtils.writeList(bb, message.interfaces);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnGetInterfacesReplyVer12: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGetInterfacesReplyVer12Funnel
    implements Funnel<OFBsnGetInterfacesReplyVer12> {
        private static final long serialVersionUID = 1L;

        OFBsnGetInterfacesReplyVer12Funnel() {
        }

        public void funnel(OFBsnGetInterfacesReplyVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(10);
            FunnelUtils.putList(message.interfaces, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGetInterfacesReply> {
        Reader() {
        }

        @Override
        public OFBsnGetInterfacesReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 10) {
                throw new OFParseError("Wrong subtype: Expected=0xaL(0xaL), got=" + subtype);
            }
            List<OFBsnInterface> interfaces = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnInterfaceVer12.READER);
            OFBsnGetInterfacesReplyVer12 bsnGetInterfacesReplyVer12 = new OFBsnGetInterfacesReplyVer12(xid, interfaces);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGetInterfacesReplyVer12);
            }
            return bsnGetInterfacesReplyVer12;
        }
    }

    static class Builder
    implements OFBsnGetInterfacesReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean interfacesSet;
        private List<OFBsnInterface> interfaces;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetInterfacesReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 10L;
        }

        @Override
        public List<OFBsnInterface> getInterfaces() {
            return this.interfaces;
        }

        @Override
        public OFBsnGetInterfacesReply.Builder setInterfaces(List<OFBsnInterface> interfaces) {
            this.interfaces = interfaces;
            this.interfacesSet = true;
            return this;
        }

        @Override
        public OFBsnGetInterfacesReply build() {
            List<OFBsnInterface> interfaces;
            long xid = this.xidSet ? this.xid : 0L;
            List<OFBsnInterface> list = interfaces = this.interfacesSet ? this.interfaces : DEFAULT_INTERFACES;
            if (interfaces == null) {
                throw new NullPointerException("Property interfaces must not be null");
            }
            return new OFBsnGetInterfacesReplyVer12(xid, interfaces);
        }
    }

    static class BuilderWithParent
    implements OFBsnGetInterfacesReply.Builder {
        final OFBsnGetInterfacesReplyVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean interfacesSet;
        private List<OFBsnInterface> interfaces;

        BuilderWithParent(OFBsnGetInterfacesReplyVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetInterfacesReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 10L;
        }

        @Override
        public List<OFBsnInterface> getInterfaces() {
            return this.interfaces;
        }

        @Override
        public OFBsnGetInterfacesReply.Builder setInterfaces(List<OFBsnInterface> interfaces) {
            this.interfaces = interfaces;
            this.interfacesSet = true;
            return this;
        }

        @Override
        public OFBsnGetInterfacesReply build() {
            List interfaces;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            List list = interfaces = this.interfacesSet ? this.interfaces : this.parentMessage.interfaces;
            if (interfaces == null) {
                throw new NullPointerException("Property interfaces must not be null");
            }
            return new OFBsnGetInterfacesReplyVer12(xid, interfaces);
        }
    }
}

