/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBucketCounter;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBucketCounterVer11
implements OFBucketCounter {
    private static final Logger logger = LoggerFactory.getLogger(OFBucketCounterVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 16;
    private static final U64 DEFAULT_PACKET_COUNT = U64.ZERO;
    private static final U64 DEFAULT_BYTE_COUNT = U64.ZERO;
    private final U64 packetCount;
    private final U64 byteCount;
    static final OFBucketCounterVer11 DEFAULT = new OFBucketCounterVer11(DEFAULT_PACKET_COUNT, DEFAULT_BYTE_COUNT);
    static final Reader READER = new Reader();
    static final OFBucketCounterVer11Funnel FUNNEL = new OFBucketCounterVer11Funnel();
    static final Writer WRITER = new Writer();

    OFBucketCounterVer11(U64 packetCount, U64 byteCount) {
        if (packetCount == null) {
            throw new NullPointerException("OFBucketCounterVer11: property packetCount cannot be null");
        }
        if (byteCount == null) {
            throw new NullPointerException("OFBucketCounterVer11: property byteCount cannot be null");
        }
        this.packetCount = packetCount;
        this.byteCount = byteCount;
    }

    @Override
    public U64 getPacketCount() {
        return this.packetCount;
    }

    @Override
    public U64 getByteCount() {
        return this.byteCount;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFBucketCounter.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBucketCounterVer11(");
        b.append("packetCount=").append(this.packetCount);
        b.append(", ");
        b.append("byteCount=").append(this.byteCount);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBucketCounterVer11 other = (OFBucketCounterVer11)obj;
        if (this.packetCount == null ? other.packetCount != null : !this.packetCount.equals(other.packetCount)) {
            return false;
        }
        return !(this.byteCount == null ? other.byteCount != null : !this.byteCount.equals(other.byteCount));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.packetCount == null ? 0 : this.packetCount.hashCode());
        result = 31 * result + (this.byteCount == null ? 0 : this.byteCount.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBucketCounterVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBucketCounterVer11 message) {
            bb.writeLong(message.packetCount.getValue());
            bb.writeLong(message.byteCount.getValue());
        }
    }

    static class OFBucketCounterVer11Funnel
    implements Funnel<OFBucketCounterVer11> {
        private static final long serialVersionUID = 1L;

        OFBucketCounterVer11Funnel() {
        }

        public void funnel(OFBucketCounterVer11 message, PrimitiveSink sink) {
            message.packetCount.putTo(sink);
            message.byteCount.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBucketCounter> {
        Reader() {
        }

        @Override
        public OFBucketCounter readFrom(ByteBuf bb) throws OFParseError {
            U64 packetCount = U64.ofRaw(bb.readLong());
            U64 byteCount = U64.ofRaw(bb.readLong());
            OFBucketCounterVer11 bucketCounterVer11 = new OFBucketCounterVer11(packetCount, byteCount);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bucketCounterVer11);
            }
            return bucketCounterVer11;
        }
    }

    static class Builder
    implements OFBucketCounter.Builder {
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;

        Builder() {
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFBucketCounter.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFBucketCounter.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFBucketCounter build() {
            U64 byteCount;
            U64 packetCount;
            U64 u64 = packetCount = this.packetCountSet ? this.packetCount : DEFAULT_PACKET_COUNT;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u642 = byteCount = this.byteCountSet ? this.byteCount : DEFAULT_BYTE_COUNT;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            return new OFBucketCounterVer11(packetCount, byteCount);
        }
    }

    static class BuilderWithParent
    implements OFBucketCounter.Builder {
        final OFBucketCounterVer11 parentMessage;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;

        BuilderWithParent(OFBucketCounterVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFBucketCounter.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFBucketCounter.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFBucketCounter build() {
            U64 byteCount;
            U64 packetCount;
            U64 u64 = packetCount = this.packetCountSet ? this.packetCount : this.parentMessage.packetCount;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u642 = byteCount = this.byteCountSet ? this.byteCount : this.parentMessage.byteCount;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            return new OFBucketCounterVer11(packetCount, byteCount);
        }
    }
}

