/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPduRxRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnPduRxRequestVer11
implements OFBsnPduRxRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnPduRxRequestVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 28;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_TIMEOUT_MS = 0L;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final short DEFAULT_SLOT_NUM = 0;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final long timeoutMs;
    private final OFPort portNo;
    private final short slotNum;
    private final byte[] data;
    static final OFBsnPduRxRequestVer11 DEFAULT = new OFBsnPduRxRequestVer11(0L, 0L, DEFAULT_PORT_NO, 0, DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFBsnPduRxRequestVer11Funnel FUNNEL = new OFBsnPduRxRequestVer11Funnel();
    static final Writer WRITER = new Writer();

    OFBsnPduRxRequestVer11(long xid, long timeoutMs, OFPort portNo, short slotNum, byte[] data) {
        if (portNo == null) {
            throw new NullPointerException("OFBsnPduRxRequestVer11: property portNo cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFBsnPduRxRequestVer11: property data cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.timeoutMs = U32.normalize(timeoutMs);
        this.portNo = portNo;
        this.slotNum = U8.normalize(slotNum);
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 33L;
    }

    @Override
    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public short getSlotNum() {
        return this.slotNum;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFBsnPduRxRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnPduRxRequestVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("timeoutMs=").append(this.timeoutMs);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("slotNum=").append(this.slotNum);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPduRxRequestVer11 other = (OFBsnPduRxRequestVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.slotNum != other.slotNum) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPduRxRequestVer11 other = (OFBsnPduRxRequestVer11)obj;
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.slotNum != other.slotNum) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.timeoutMs ^ this.timeoutMs >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.slotNum;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.timeoutMs ^ this.timeoutMs >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.slotNum;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnPduRxRequestVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnPduRxRequestVer11 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(2);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(33);
            bb.writeInt(U32.t(message.timeoutMs));
            message.portNo.write4Bytes(bb);
            bb.writeByte((int)U8.t(message.slotNum));
            bb.writeZero(3);
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnPduRxRequestVer11: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnPduRxRequestVer11Funnel
    implements Funnel<OFBsnPduRxRequestVer11> {
        private static final long serialVersionUID = 1L;

        OFBsnPduRxRequestVer11Funnel() {
        }

        public void funnel(OFBsnPduRxRequestVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(33);
            sink.putLong(message.timeoutMs);
            message.portNo.putTo(sink);
            sink.putShort(message.slotNum);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnPduRxRequest> {
        Reader() {
        }

        @Override
        public OFBsnPduRxRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 28) {
                throw new OFParseError("Wrong length: Expected to be >= 28, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 33) {
                throw new OFParseError("Wrong subtype: Expected=0x21L(0x21L), got=" + subtype);
            }
            long timeoutMs = U32.f(bb.readInt());
            OFPort portNo = OFPort.read4Bytes(bb);
            short slotNum = U8.f(bb.readByte());
            bb.skipBytes(3);
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnPduRxRequestVer11 bsnPduRxRequestVer11 = new OFBsnPduRxRequestVer11(xid, timeoutMs, portNo, slotNum, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnPduRxRequestVer11);
            }
            return bsnPduRxRequestVer11;
        }
    }

    static class Builder
    implements OFBsnPduRxRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean timeoutMsSet;
        private long timeoutMs;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean slotNumSet;
        private short slotNum;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPduRxRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 33L;
        }

        @Override
        public long getTimeoutMs() {
            return this.timeoutMs;
        }

        @Override
        public OFBsnPduRxRequest.Builder setTimeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            this.timeoutMsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPduRxRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public short getSlotNum() {
            return this.slotNum;
        }

        @Override
        public OFBsnPduRxRequest.Builder setSlotNum(short slotNum) {
            this.slotNum = slotNum;
            this.slotNumSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnPduRxRequest.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnPduRxRequest build() {
            byte[] data;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : 0L;
            long timeoutMs = this.timeoutMsSet ? this.timeoutMs : 0L;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            short slotNum = this.slotNumSet ? this.slotNum : (short)0;
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnPduRxRequestVer11(xid, timeoutMs, portNo, slotNum, data);
        }
    }

    static class BuilderWithParent
    implements OFBsnPduRxRequest.Builder {
        final OFBsnPduRxRequestVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean timeoutMsSet;
        private long timeoutMs;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean slotNumSet;
        private short slotNum;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFBsnPduRxRequestVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPduRxRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 33L;
        }

        @Override
        public long getTimeoutMs() {
            return this.timeoutMs;
        }

        @Override
        public OFBsnPduRxRequest.Builder setTimeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            this.timeoutMsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPduRxRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public short getSlotNum() {
            return this.slotNum;
        }

        @Override
        public OFBsnPduRxRequest.Builder setSlotNum(short slotNum) {
            this.slotNum = slotNum;
            this.slotNumSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnPduRxRequest.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnPduRxRequest build() {
            byte[] data;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long timeoutMs = this.timeoutMsSet ? this.timeoutMs : this.parentMessage.timeoutMs;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            short slotNum = this.slotNumSet ? this.slotNum : this.parentMessage.slotNum;
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnPduRxRequestVer11(xid, timeoutMs, portNo, slotNum, data);
        }
    }
}

