/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnBwClearDataReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnBwClearDataReplyVer11
implements OFBsnBwClearDataReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnBwClearDataReplyVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_STATUS = 0L;
    private final long xid;
    private final long status;
    static final OFBsnBwClearDataReplyVer11 DEFAULT = new OFBsnBwClearDataReplyVer11(0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnBwClearDataReplyVer11Funnel FUNNEL = new OFBsnBwClearDataReplyVer11Funnel();
    static final Writer WRITER = new Writer();

    OFBsnBwClearDataReplyVer11(long xid, long status) {
        this.xid = U32.normalize(xid);
        this.status = U32.normalize(status);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 22L;
    }

    @Override
    public long getStatus() {
        return this.status;
    }

    @Override
    public OFBsnBwClearDataReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnBwClearDataReplyVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("status=").append(this.status);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnBwClearDataReplyVer11 other = (OFBsnBwClearDataReplyVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.status == other.status;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnBwClearDataReplyVer11 other = (OFBsnBwClearDataReplyVer11)obj;
        return this.status == other.status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.status ^ this.status >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnBwClearDataReplyVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnBwClearDataReplyVer11 message) {
            bb.writeByte(2);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(22);
            bb.writeInt(U32.t(message.status));
        }
    }

    static class OFBsnBwClearDataReplyVer11Funnel
    implements Funnel<OFBsnBwClearDataReplyVer11> {
        private static final long serialVersionUID = 1L;

        OFBsnBwClearDataReplyVer11Funnel() {
        }

        public void funnel(OFBsnBwClearDataReplyVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(22);
            sink.putLong(message.status);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnBwClearDataReply> {
        Reader() {
        }

        @Override
        public OFBsnBwClearDataReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 22) {
                throw new OFParseError("Wrong subtype: Expected=0x16L(0x16L), got=" + subtype);
            }
            long status = U32.f(bb.readInt());
            OFBsnBwClearDataReplyVer11 bsnBwClearDataReplyVer11 = new OFBsnBwClearDataReplyVer11(xid, status);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnBwClearDataReplyVer11);
            }
            return bsnBwClearDataReplyVer11;
        }
    }

    static class Builder
    implements OFBsnBwClearDataReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwClearDataReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 22L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnBwClearDataReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFBsnBwClearDataReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            long status = this.statusSet ? this.status : 0L;
            return new OFBsnBwClearDataReplyVer11(xid, status);
        }
    }

    static class BuilderWithParent
    implements OFBsnBwClearDataReply.Builder {
        final OFBsnBwClearDataReplyVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;

        BuilderWithParent(OFBsnBwClearDataReplyVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwClearDataReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 22L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnBwClearDataReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFBsnBwClearDataReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long status = this.statusSet ? this.status : this.parentMessage.status;
            return new OFBsnBwClearDataReplyVer11(xid, status);
        }
    }
}

