/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionOutputVer10
implements OFActionOutput {
    private static final Logger logger = LoggerFactory.getLogger(OFActionOutputVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 8;
    private static final OFPort DEFAULT_PORT = OFPort.ANY;
    private static final int DEFAULT_MAX_LEN = 0;
    private final OFPort port;
    private final int maxLen;
    static final OFActionOutputVer10 DEFAULT = new OFActionOutputVer10(DEFAULT_PORT, 0);
    static final Reader READER = new Reader();
    static final OFActionOutputVer10Funnel FUNNEL = new OFActionOutputVer10Funnel();
    static final Writer WRITER = new Writer();

    OFActionOutputVer10(OFPort port, int maxLen) {
        if (port == null) {
            throw new NullPointerException("OFActionOutputVer10: property port cannot be null");
        }
        this.port = port;
        this.maxLen = U16.normalize(maxLen);
    }

    @Override
    public OFActionType getType() {
        return OFActionType.OUTPUT;
    }

    @Override
    public OFPort getPort() {
        return this.port;
    }

    @Override
    public int getMaxLen() {
        return this.maxLen;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFActionOutput.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionOutputVer10(");
        b.append("port=").append(this.port);
        b.append(", ");
        b.append("maxLen=").append(this.maxLen);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionOutputVer10 other = (OFActionOutputVer10)obj;
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        return this.maxLen == other.maxLen;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + this.maxLen;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionOutputVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionOutputVer10 message) {
            bb.writeShort(0);
            bb.writeShort(8);
            message.port.write2Bytes(bb);
            bb.writeShort((int)U16.t(message.maxLen));
        }
    }

    static class OFActionOutputVer10Funnel
    implements Funnel<OFActionOutputVer10> {
        private static final long serialVersionUID = 1L;

        OFActionOutputVer10Funnel() {
        }

        public void funnel(OFActionOutputVer10 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)8);
            message.port.putTo(sink);
            sink.putInt(message.maxLen);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionOutput> {
        Reader() {
        }

        @Override
        public OFActionOutput readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=OFActionType.OUTPUT(0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFPort port = OFPort.read2Bytes(bb);
            int maxLen = U16.f(bb.readShort());
            OFActionOutputVer10 actionOutputVer10 = new OFActionOutputVer10(port, maxLen);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionOutputVer10);
            }
            return actionOutputVer10;
        }
    }

    static class Builder
    implements OFActionOutput.Builder {
        private boolean portSet;
        private OFPort port;
        private boolean maxLenSet;
        private int maxLen;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.OUTPUT;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFActionOutput.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public int getMaxLen() {
            return this.maxLen;
        }

        @Override
        public OFActionOutput.Builder setMaxLen(int maxLen) {
            this.maxLen = maxLen;
            this.maxLenSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionOutput build() {
            OFPort port;
            OFPort oFPort = port = this.portSet ? this.port : DEFAULT_PORT;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            int maxLen = this.maxLenSet ? this.maxLen : 0;
            return new OFActionOutputVer10(port, maxLen);
        }
    }

    static class BuilderWithParent
    implements OFActionOutput.Builder {
        final OFActionOutputVer10 parentMessage;
        private boolean portSet;
        private OFPort port;
        private boolean maxLenSet;
        private int maxLen;

        BuilderWithParent(OFActionOutputVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.OUTPUT;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFActionOutput.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public int getMaxLen() {
            return this.maxLen;
        }

        @Override
        public OFActionOutput.Builder setMaxLen(int maxLen) {
            this.maxLen = maxLen;
            this.maxLenSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionOutput build() {
            OFPort port;
            OFPort oFPort = port = this.portSet ? this.port : this.parentMessage.port;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            int maxLen = this.maxLenSet ? this.maxLen : this.parentMessage.maxLen;
            return new OFActionOutputVer10(port, maxLen);
        }
    }
}

