/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.action.OFActionNicira;
import org.projectfloodlight.openflow.protocol.ver10.OFActionNiciraDecTtlVer10;
import org.projectfloodlight.openflow.types.U16;

abstract class OFActionNiciraVer10 {
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFActionNiciraVer10() {
    }

    static class Reader
    implements OFMessageReader<OFActionNicira> {
        Reader() {
        }

        @Override
        public OFActionNicira readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            int experimenter = bb.readInt();
            if (experimenter != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            bb.readerIndex(start);
            switch (subtype) {
                case 18: {
                    return OFActionNiciraDecTtlVer10.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFActionNiciraVer10: " + subtype);
        }
    }
}

