/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.protocol.match;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;

public class PrimitiveNormalizationTest {
    private final OFFactory factory = OFFactories.getFactory((OFVersion)OFVersion.OF_14);

    @Test
    public void normalizeU8() {
        MatcherAssert.assertThat((Object)this.factory.bsnTlvs().vlanPcp((short)-1), (Matcher)CoreMatchers.equalTo((Object)this.factory.bsnTlvs().vlanPcp((short)255)));
        MatcherAssert.assertThat((Object)this.factory.bsnTlvs().vlanPcp((short)-1), (Matcher)CoreMatchers.not((Object)this.factory.bsnTlvs().vlanPcp((short)0)));
        MatcherAssert.assertThat((Object)this.factory.bsnTlvs().vlanPcp((short)-1), (Matcher)CoreMatchers.not((Object)this.factory.bsnTlvs().vlanPcp((short)1)));
        MatcherAssert.assertThat((Object)this.factory.bsnTlvs().vlanPcp((short)1), (Matcher)CoreMatchers.not((Object)this.factory.bsnTlvs().vlanPcp((short)2)));
        MatcherAssert.assertThat((Object)this.factory.bsnTlvs().vlanPcp((short)-1), (Matcher)CoreMatchers.not((Object)this.factory.bsnTlvs().vlanPcp((short)-2)));
        MatcherAssert.assertThat((Object)this.factory.bsnTlvs().buildVlanPcp().setValue((short)-1).build(), (Matcher)CoreMatchers.equalTo((Object)this.factory.bsnTlvs().vlanPcp((short)255)));
    }

    @Test
    public void normalizeU16() {
        MatcherAssert.assertThat((Object)this.factory.actions().output(OFPort.of((int)1), -1), (Matcher)CoreMatchers.equalTo((Object)this.factory.actions().output(OFPort.of((int)1), 65535)));
        MatcherAssert.assertThat((Object)this.factory.actions().output(OFPort.of((int)1), -1), (Matcher)CoreMatchers.not((Object)this.factory.actions().output(OFPort.of((int)1), 0)));
        MatcherAssert.assertThat((Object)this.factory.actions().output(OFPort.of((int)1), -1), (Matcher)CoreMatchers.not((Object)this.factory.actions().output(OFPort.of((int)1), 1)));
        MatcherAssert.assertThat((Object)this.factory.actions().buildOutput().setPort(OFPort.of((int)1)).setMaxLen(-1).build(), (Matcher)CoreMatchers.equalTo((Object)this.factory.actions().output(OFPort.of((int)1), 65535)));
    }

    @Test
    public void normalizeU32() {
        MatcherAssert.assertThat((Object)this.factory.bsnTlvs().mplsLabel(-1L), (Matcher)CoreMatchers.equalTo((Object)this.factory.bsnTlvs().mplsLabel(0xFFFFFFFFFL)));
        MatcherAssert.assertThat((Object)this.factory.bsnTlvs().mplsLabel(-1L), (Matcher)CoreMatchers.not((Object)this.factory.bsnTlvs().mplsLabel(1L)));
        MatcherAssert.assertThat((Object)this.factory.bsnTlvs().mplsLabel(-1L), (Matcher)CoreMatchers.not((Object)this.factory.bsnTlvs().mplsLabel(0L)));
        MatcherAssert.assertThat((Object)this.factory.bsnTlvs().buildMplsLabel().setValue(-1L).build(), (Matcher)CoreMatchers.equalTo((Object)this.factory.bsnTlvs().mplsLabel(0xFFFFFFFFFL)));
    }
}

