/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.protocol;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;

public class OFPortDescTest {
    @Test
    public void testIsEnabled() {
        this.testIsEnabledForFactory(OFFactories.getFactory((OFVersion)OFVersion.OF_10));
        this.testIsEnabledForFactory(OFFactories.getFactory((OFVersion)OFVersion.OF_11));
        this.testIsEnabledForFactory(OFFactories.getFactory((OFVersion)OFVersion.OF_12));
        this.testIsEnabledForFactory(OFFactories.getFactory((OFVersion)OFVersion.OF_13));
        this.testIsEnabledForFactory(OFFactories.getFactory((OFVersion)OFVersion.OF_14));
    }

    public void testIsEnabledForFactory(OFFactory factory) {
        OFPortDesc desc = factory.buildPortDesc().build();
        MatcherAssert.assertThat((Object)desc.isEnabled(), (Matcher)Matchers.is((Object)true));
        desc = factory.buildPortDesc().setConfig(new HashSet<OFPortConfig>(Arrays.asList(OFPortConfig.PORT_DOWN))).build();
        MatcherAssert.assertThat((Object)desc.isEnabled(), (Matcher)Matchers.is((Object)false));
        desc = factory.buildPortDesc().setConfig(new HashSet<OFPortConfig>(Arrays.asList(OFPortConfig.PORT_DOWN))).setState(new HashSet<OFPortState>(Arrays.asList(OFPortState.LINK_DOWN))).build();
        MatcherAssert.assertThat((Object)desc.isEnabled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGenerationIdZeroIfUnset() {
        for (OFVersion v : OFVersion.values()) {
            OFFactory factory = OFFactories.getFactory((OFVersion)v);
            MatcherAssert.assertThat((String)("For version " + v), (Object)factory.buildPortDesc().build().getBsnGenerationId(), (Matcher)Matchers.equalTo((Object)U64.ZERO));
        }
    }

    @Test
    public void testGenerationIdSet() {
        OFFactory factory = OFFactories.getFactory((OFVersion)OFVersion.OF_14);
        OFPortDesc desc = factory.buildPortDesc().setProperties((List)ImmutableList.of((Object)factory.portDescPropBsnGenerationId(U64.of((long)1234L)))).build();
        MatcherAssert.assertThat((Object)desc.getBsnGenerationId(), (Matcher)CoreMatchers.equalTo((Object)U64.of((long)1234L)));
    }
}

