/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.protocol;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFOxmList;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6DstMasked;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6SrcMasked;
import org.projectfloodlight.openflow.protocol.oxm.OFOxms;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.IPv6AddressWithMask;

public class OFOxmListTest {
    private OFOxms oxms;

    @Before
    public void setup() {
        this.oxms = OFFactories.getFactory((OFVersion)OFVersion.OF_13).oxms();
    }

    @Test
    public void testCanonicalize() {
        OFOxmList.Builder builder = new OFOxmList.Builder();
        IPv6AddressWithMask fullMasked = IPv6AddressWithMask.of((String)"::/0");
        OFOxmIpv6DstMasked fullMaskedOxm = this.oxms.ipv6DstMasked((IPv6Address)fullMasked.getValue(), (IPv6Address)fullMasked.getMask());
        builder.set((OFOxm)fullMaskedOxm);
        IPv6AddressWithMask address = IPv6AddressWithMask.of((String)"1:2:3:4:5:6::8");
        OFOxmIpv6SrcMasked addressSrcOxm = this.oxms.ipv6SrcMasked((IPv6Address)address.getValue(), (IPv6Address)address.getMask());
        builder.set((OFOxm)addressSrcOxm);
        OFOxmList list = builder.build();
        MatcherAssert.assertThat((Object)list.get(MatchField.IPV6_DST), (Matcher)CoreMatchers.nullValue());
        Assert.assertFalse((boolean)list.get(MatchField.IPV6_SRC).isMasked());
    }
}

