/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.text.MessageFormat;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.types.U128;

public class U128Test {
    private Triple[] triples;

    @Test
    public void testPositiveRaws() {
        MatcherAssert.assertThat((Object)U128.of((long)0L, (long)0L).getMsb(), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)U128.of((long)0L, (long)0L).getLsb(), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)U128.of((long)1L, (long)2L).getMsb(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)U128.of((long)1L, (long)2L).getLsb(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void testReadBytes() {
        ByteBuf empty = Unpooled.wrappedBuffer((byte[])new byte[16]);
        U128 uEmpty = U128.read16Bytes((ByteBuf)empty);
        MatcherAssert.assertThat((Object)uEmpty.getMsb(), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)uEmpty.getLsb(), (Matcher)CoreMatchers.equalTo((Object)0L));
        ByteBuf value = Unpooled.wrappedBuffer((byte[])new byte[]{17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1, 17});
        U128 uValue = U128.read16Bytes((ByteBuf)value);
        MatcherAssert.assertThat((Object)uValue.getMsb(), (Matcher)CoreMatchers.equalTo((Object)1234605616436508552L));
        MatcherAssert.assertThat((Object)uValue.getLsb(), (Matcher)CoreMatchers.equalTo((Object)-7373874951294615791L));
    }

    @Test
    public void testPutTo() {
        U128 h = U128.of((long)1311768467294899695L, (long)-2400490138922795281L);
        U128 hSame = U128.of((long)1311768467294899695L, (long)-2400490138922795281L);
        U128 hBothDiff = U128.of((long)1311768467294899695L, (long)1311768467294899695L);
        U128 hMsbDiff = U128.of((long)158846962688052719L, (long)-2400490138922795281L);
        U128 hLsbDiff = U128.of((long)1311768467294899695L, (long)-2400490138922795282L);
        MatcherAssert.assertThat((Object)this.hash(h), (Matcher)CoreMatchers.equalTo((Object)this.hash(hSame)));
        MatcherAssert.assertThat((Object)this.hash(h), (Matcher)CoreMatchers.not((Object)this.hash(hBothDiff)));
        MatcherAssert.assertThat((Object)this.hash(h), (Matcher)CoreMatchers.not((Object)this.hash(hMsbDiff)));
        MatcherAssert.assertThat((Object)this.hash(h), (Matcher)CoreMatchers.not((Object)this.hash(hLsbDiff)));
    }

    private HashCode hash(U128 f) {
        Hasher hash = Hashing.murmur3_128().newHasher();
        f.putTo((PrimitiveSink)hash);
        return hash.hash();
    }

    @Test
    public void testEqualHashCode() {
        U128 h1 = U128.of((long)-2400490138922795281L, (long)-2400490138922795281L);
        U128 h2 = U128.of((long)-2400490138922795281L, (long)-2400490138922795281L);
        U128 h3 = U128.of((long)-1247568634315948305L, (long)-2400490138922795281L);
        U128 h3_2 = U128.of((long)-2400490138922795281L, (long)-1247568634315948305L);
        Assert.assertTrue((boolean)h1.equals((Object)h1));
        Assert.assertTrue((boolean)h1.equals((Object)h2));
        Assert.assertFalse((boolean)h1.equals((Object)h3));
        Assert.assertFalse((boolean)h1.equals((Object)h3_2));
        Assert.assertTrue((boolean)h2.equals((Object)h1));
        Assert.assertEquals((long)h1.hashCode(), (long)h2.hashCode());
        Assert.assertNotEquals((long)h1.hashCode(), (long)h3.hashCode());
        Assert.assertNotEquals((long)h1.hashCode(), (long)h3_2.hashCode());
    }

    @Test
    public void testXor() {
        U128 hNull = U128.of((long)0L, (long)0L);
        U128 hDeadBeef = U128.of((long)-2400490138922795281L, (long)-2400490138922795281L);
        MatcherAssert.assertThat((Object)hNull.xor(hNull), (Matcher)CoreMatchers.equalTo((Object)hNull));
        MatcherAssert.assertThat((Object)hNull.xor(hDeadBeef), (Matcher)CoreMatchers.equalTo((Object)hDeadBeef));
        MatcherAssert.assertThat((Object)hDeadBeef.xor(hNull), (Matcher)CoreMatchers.equalTo((Object)hDeadBeef));
        MatcherAssert.assertThat((Object)hDeadBeef.xor(hDeadBeef), (Matcher)CoreMatchers.equalTo((Object)hNull));
        U128 h1_0 = U128.of((long)1L, (long)0L);
        U128 h8_0 = U128.of((long)Long.MIN_VALUE, (long)0L);
        U128 h81_0 = U128.of((long)-9223372036854775807L, (long)0L);
        MatcherAssert.assertThat((Object)h1_0.xor(h8_0), (Matcher)CoreMatchers.equalTo((Object)h81_0));
        U128 h0_1 = U128.of((long)0L, (long)1L);
        U128 h0_8 = U128.of((long)0L, (long)Long.MIN_VALUE);
        U128 h0_81 = U128.of((long)0L, (long)-9223372036854775807L);
        MatcherAssert.assertThat((Object)h0_1.xor(h0_8), (Matcher)CoreMatchers.equalTo((Object)h0_81));
    }

    @Test
    public void testKeyBits() {
        U128 zeroU = U128.of((long)0L, (long)0L);
        MatcherAssert.assertThat((Object)zeroU.prefixBits(0), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)zeroU.prefixBits(16), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)zeroU.prefixBits(32), (Matcher)CoreMatchers.equalTo((Object)0));
        this.checkInvalidKeyBitSize(zeroU, 33);
        this.checkInvalidKeyBitSize(zeroU, 64);
        MatcherAssert.assertThat((Object)zeroU.prefixBits(3), (Matcher)CoreMatchers.equalTo((Object)0));
        U128 positiveU = U128.of((long)1311768465173141112L, (long)1311768465173141112L);
        MatcherAssert.assertThat((Object)positiveU.prefixBits(0), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)positiveU.prefixBits(16), (Matcher)CoreMatchers.equalTo((Object)4660));
        MatcherAssert.assertThat((Object)positiveU.prefixBits(32), (Matcher)CoreMatchers.equalTo((Object)305419896));
        this.checkInvalidKeyBitSize(positiveU, 33);
        this.checkInvalidKeyBitSize(positiveU, 64);
        U128 signedBitU = U128.of((long)-8690466094656961759L, (long)1311768465173141112L);
        MatcherAssert.assertThat((Object)signedBitU.prefixBits(0), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)signedBitU.prefixBits(16), (Matcher)CoreMatchers.equalTo((Object)34661));
        MatcherAssert.assertThat((Object)signedBitU.prefixBits(32), (Matcher)CoreMatchers.equalTo((Object)-2023406815));
        this.checkInvalidKeyBitSize(signedBitU, 33);
        this.checkInvalidKeyBitSize(signedBitU, 64);
    }

    private void checkInvalidKeyBitSize(U128 u, int prefixBit) {
        try {
            u.prefixBits(prefixBit);
            Assert.fail((String)("Expected exception not thrown for " + prefixBit + " bits"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Before
    public void setup() {
        U128 u0_0 = U128.of((long)0L, (long)0L);
        U128 u0_1 = U128.of((long)0L, (long)1L);
        U128 u1_0 = U128.of((long)1L, (long)0L);
        U128 u1_1 = U128.of((long)1L, (long)1L);
        U128 u0_2 = U128.of((long)0L, (long)2L);
        U128 u2_0 = U128.of((long)2L, (long)0L);
        U128 u0_f = U128.of((long)0L, (long)-1L);
        U128 uf_0 = U128.of((long)-1L, (long)0L);
        this.triples = new Triple[]{Triple.of(u0_0, u0_0, u0_0), Triple.of(u0_0, u0_1, u0_1), Triple.of(u0_0, u1_0, u1_0), Triple.of(u0_1, u1_0, u1_1), Triple.of(u0_1, u0_1, u0_2), Triple.of(u1_0, u1_0, u2_0), Triple.of(u0_1, u0_f, u1_0), Triple.of(u0_1, u0_f, u1_0), Triple.of(u0_f, u0_f, U128.of((long)1L, (long)-2L)), Triple.of(uf_0, u0_f, U128.of((long)-1L, (long)-1L)), Triple.of(uf_0, u1_0, U128.ZERO), Triple.of(U128.of((long)1311768467463790321L, (long)1311768467463790321L), U128.of((long)-1311768467463790322L, (long)-1311768467463790321L), U128.ZERO)};
    }

    @Test
    public void testAddSubtract() {
        for (Triple t : this.triples) {
            MatcherAssert.assertThat((String)t.msg("{0} + {1} = {2}"), (Object)t.a.add(t.b), (Matcher)CoreMatchers.equalTo((Object)t.c));
            MatcherAssert.assertThat((String)t.msg("{1} + {0} = {2}"), (Object)t.b.add(t.a), (Matcher)CoreMatchers.equalTo((Object)t.c));
            MatcherAssert.assertThat((String)t.msg("{2} - {0} = {1}"), (Object)t.c.subtract(t.a), (Matcher)CoreMatchers.equalTo((Object)t.b));
            MatcherAssert.assertThat((String)t.msg("{2} - {1} = {0}"), (Object)t.c.subtract(t.b), (Matcher)CoreMatchers.equalTo((Object)t.a));
        }
    }

    @Test
    public void testAddSubtractBuilder() {
        for (Triple t : this.triples) {
            MatcherAssert.assertThat((String)t.msg("{0} + {1} = {2}"), (Object)t.a.builder().add((Object)t.b).build(), (Matcher)CoreMatchers.equalTo((Object)t.c));
            MatcherAssert.assertThat((String)t.msg("{1} + {0} = {2}"), (Object)t.b.builder().add((Object)t.a).build(), (Matcher)CoreMatchers.equalTo((Object)t.c));
            MatcherAssert.assertThat((String)t.msg("{2} - {0} = {1}"), (Object)t.c.builder().subtract((Object)t.a).build(), (Matcher)CoreMatchers.equalTo((Object)t.b));
            MatcherAssert.assertThat((String)t.msg("{2} - {1} = {0}"), (Object)t.c.builder().subtract((Object)t.b).build(), (Matcher)CoreMatchers.equalTo((Object)t.a));
        }
    }

    @Test
    public void testCompare() {
        U128 u0_0 = U128.of((long)0L, (long)0L);
        U128 u0_1 = U128.of((long)0L, (long)1L);
        U128 u0_8 = U128.of((long)0L, (long)-8690466094656961759L);
        U128 u1_0 = U128.of((long)1311768465173141112L, (long)0L);
        U128 u8_0 = U128.of((long)-8690466094656961759L, (long)0L);
        U128 uf_0 = U128.of((long)-1L, (long)0L);
        U128[] us = new U128[]{u0_0, u0_1, u0_8, u1_0, u8_0, uf_0};
        for (int i = 0; i < us.length; ++i) {
            U128 u_base = us[i];
            MatcherAssert.assertThat((String)String.format("%s should be equal to itself (compareTo)", u_base), (Object)u_base.compareTo(u_base), (Matcher)CoreMatchers.equalTo((Object)0));
            MatcherAssert.assertThat((String)String.format("%s should be equal to itself (equals)", u_base), (Object)u_base.equals((Object)u_base), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((String)String.format("%s should be equal to itself (equals, by value)", u_base), (Object)u_base.equals((Object)U128.of((long)u_base.getMsb(), (long)u_base.getLsb())), (Matcher)CoreMatchers.equalTo((Object)true));
            for (int j = i + 1; j < us.length; ++j) {
                U128 u_greater = us[j];
                MatcherAssert.assertThat((String)String.format("%s should not be equal to %s", u_base, u_greater), (Object)u_base.equals((Object)u_base), (Matcher)CoreMatchers.equalTo((Object)true));
                MatcherAssert.assertThat((String)String.format("%s should be smaller than %s", u_base, u_greater), (Object)u_base.compareTo(u_greater), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
                MatcherAssert.assertThat((String)String.format("%s should be greater than %s", u_greater, u_base), (Object)u_greater.compareTo(u_base), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            }
        }
    }

    @Test
    public void testBitwiseOperators() {
        U128 one = U128.of((long)5L, (long)8L);
        U128 two = U128.of((long)7L, (long)3L);
        MatcherAssert.assertThat((Object)one.inverse(), (Matcher)CoreMatchers.equalTo((Object)U128.of((long)-6L, (long)-9L)));
        MatcherAssert.assertThat((Object)one.and(two), (Matcher)CoreMatchers.equalTo((Object)U128.of((long)5L, (long)0L)));
        MatcherAssert.assertThat((Object)one.or(two), (Matcher)CoreMatchers.equalTo((Object)U128.of((long)7L, (long)11L)));
        MatcherAssert.assertThat((Object)one.xor(two), (Matcher)CoreMatchers.equalTo((Object)U128.of((long)2L, (long)11L)));
    }

    @Test
    public void testBitwiseOperatorsBuilder() {
        U128 one = U128.of((long)5L, (long)8L);
        U128 two = U128.of((long)7L, (long)3L);
        MatcherAssert.assertThat((Object)one.builder().invert().build(), (Matcher)CoreMatchers.equalTo((Object)U128.of((long)-6L, (long)-9L)));
        MatcherAssert.assertThat((Object)one.builder().and((Object)two).build(), (Matcher)CoreMatchers.equalTo((Object)U128.of((long)5L, (long)0L)));
        MatcherAssert.assertThat((Object)one.builder().or((Object)two).build(), (Matcher)CoreMatchers.equalTo((Object)U128.of((long)7L, (long)11L)));
        MatcherAssert.assertThat((Object)one.builder().xor((Object)two).build(), (Matcher)CoreMatchers.equalTo((Object)U128.of((long)2L, (long)11L)));
    }

    public static class Triple {
        U128 a;
        U128 b;
        U128 c;

        public Triple(U128 a, U128 b, U128 c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public static Triple of(U128 a, U128 b, U128 c) {
            return new Triple(a, b, c);
        }

        public String msg(String string) {
            return MessageFormat.format(string, this.a, this.b, this.c);
        }
    }
}

