/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.projectfloodlight.openflow.types.TransportPort;

public class TransportPortTest {
    @Test
    public void testOf() {
        MatcherAssert.assertThat((Object)TransportPort.of((int)1).getPort(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)TransportPort.of((int)2).getPort(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)TransportPort.of((int)65518).getPort(), (Matcher)CoreMatchers.equalTo((Object)65518));
        MatcherAssert.assertThat((Object)TransportPort.of((int)0).getPort(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)TransportPort.of((int)0), (Matcher)CoreMatchers.equalTo((Object)TransportPort.FULL_MASK));
        MatcherAssert.assertThat((Object)TransportPort.of((int)65535), (Matcher)CoreMatchers.equalTo((Object)TransportPort.NO_MASK));
        MatcherAssert.assertThat((Object)TransportPort.of((int)-1), (Matcher)CoreMatchers.equalTo((Object)TransportPort.NO_MASK));
    }

    @Test
    public void testEquals() {
        MatcherAssert.assertThat((Object)TransportPort.of((int)1), (Matcher)CoreMatchers.equalTo((Object)TransportPort.of((int)1)));
        MatcherAssert.assertThat((Object)TransportPort.of((int)1), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)TransportPort.of((int)2))));
        MatcherAssert.assertThat((Object)TransportPort.of((int)2).getPort(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)TransportPort.FULL_MASK, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)TransportPort.NO_MASK)));
        MatcherAssert.assertThat((Object)TransportPort.of((int)1).hashCode(), (Matcher)CoreMatchers.equalTo((Object)TransportPort.of((int)1).hashCode()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOfInvalidNegative() {
        TransportPort.of((int)-2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOfInvalidTooHigh() {
        TransportPort.of((int)65536);
    }

    @Test
    public void testReadWriteTwoBytes() throws Exception {
        this.readWriteTwoBytes(1, 0, 1);
        this.readWriteTwoBytes(255, 0, 255);
        this.readWriteTwoBytes(65534, 255, 254);
        this.readWriteTwoBytes(65535, 255, 255);
        this.readWriteTwoBytes(-1, 255, 255);
    }

    private void readWriteTwoBytes(int port, int ... bytes) throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        TransportPort.of((int)port).write2Bytes(buffer);
        MatcherAssert.assertThat((Object)buffer.readableBytes(), (Matcher)CoreMatchers.equalTo((Object)2));
        for (int i = 0; i < bytes.length; ++i) {
            MatcherAssert.assertThat((Object)buffer.readByte(), (Matcher)CoreMatchers.equalTo((Object)((byte)bytes[i])));
        }
        MatcherAssert.assertThat((Object)buffer.isReadable(), (Matcher)CoreMatchers.is((Object)false));
        buffer.clear();
        for (int b : bytes) {
            buffer.writeByte(b);
        }
        MatcherAssert.assertThat((Object)TransportPort.read2Bytes((ByteBuf)buffer), (Matcher)CoreMatchers.equalTo((Object)TransportPort.of((int)port)));
    }

    @Test
    public void testCompare() {
        MatcherAssert.assertThat((Object)TransportPort.of((int)1), (Matcher)Matchers.lessThan((Comparable)TransportPort.of((int)2)));
        MatcherAssert.assertThat((Object)TransportPort.of((int)Short.MAX_VALUE), (Matcher)Matchers.lessThan((Comparable)TransportPort.of((int)32768)));
        MatcherAssert.assertThat((Object)TransportPort.of((int)1), (Matcher)Matchers.lessThan((Comparable)TransportPort.of((int)65535)));
    }
}

