/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.types.OFBitMask128;
import org.projectfloodlight.openflow.types.OFBitMask512;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFPortBitMap;
import org.projectfloodlight.openflow.types.OFPortBitMap512;

public class OFPortBitMapTest
extends TestCase {
    @Test
    public void testCreateAndIterate() {
        OFPortBitMap map = OFPortBitMap.ofPorts((OFPort[])new OFPort[]{OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)5)});
        MatcherAssert.assertThat((Object)map.getOnPorts(), (Matcher)Matchers.contains((Object[])new OFPort[]{OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)5)}));
    }

    @Test
    public void testOFBitMap() {
        OFBitMask128 bitmap = OFBitMask128.of((long)-1L, (long)-39L);
        OFPortBitMap map = OFPortBitMap.of((OFBitMask128)bitmap);
        MatcherAssert.assertThat((Object)map.getOnPorts(), (Matcher)Matchers.contains((Object[])new OFPort[]{OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)5)}));
    }

    @Test
    public void testOFPortBitMap() {
        int i;
        Object[] on = new Boolean[127];
        for (int i2 = 0; i2 < 127; ++i2) {
            on[i2] = false;
        }
        OFPortBitMap.Builder builder = new OFPortBitMap.Builder();
        for (int i3 = 0; i3 < 127; i3 += 3) {
            OFPort p = OFPort.of((int)i3);
            builder.set(p);
            on[p.getPortNumber()] = true;
        }
        OFPortBitMap portmap = builder.build();
        Object[] actual = new Boolean[127];
        for (i = 0; i < 127; ++i) {
            actual[i] = false;
        }
        for (i = 0; i < 127; ++i) {
            actual[i] = portmap.isOn(OFPort.of((int)i));
        }
        Assert.assertArrayEquals((Object[])on, (Object[])actual);
        for (i = 0; i < 127; i += 7) {
            on[i] = false;
            builder.unset(OFPort.of((int)i));
        }
        portmap = builder.build();
        actual = new Boolean[127];
        for (i = 0; i < 127; ++i) {
            actual[i] = false;
        }
        for (i = 0; i < 127; ++i) {
            actual[i] = portmap.isOn(OFPort.of((int)i));
        }
        Assert.assertArrayEquals((Object[])on, (Object[])actual);
    }

    @Test
    public void testCreateAndIterate512() {
        OFPortBitMap512 map = OFPortBitMap512.ofPorts((OFPort[])new OFPort[]{OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)5)});
        MatcherAssert.assertThat((Object)map.getOnPorts(), (Matcher)Matchers.contains((Object[])new OFPort[]{OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)5)}));
    }

    @Test
    public void testOFBitMap512() {
        OFBitMask512 bitmap = OFBitMask512.of((long)-1L, (long)-1L, (long)-1L, (long)-1L, (long)-1L, (long)-1L, (long)-1L, (long)-39L);
        OFPortBitMap512 map = OFPortBitMap512.of((OFBitMask512)bitmap);
        MatcherAssert.assertThat((Object)map.getOnPorts(), (Matcher)Matchers.contains((Object[])new OFPort[]{OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)5)}));
    }

    @Test
    public void testOFPortBitMap512() {
        int i;
        Object[] on = new Boolean[511];
        for (int i2 = 0; i2 < 511; ++i2) {
            on[i2] = false;
        }
        OFPortBitMap512.Builder builder = new OFPortBitMap512.Builder();
        for (int i3 = 0; i3 < 511; i3 += 3) {
            OFPort p = OFPort.of((int)i3);
            builder.set(p);
            on[p.getPortNumber()] = true;
        }
        OFPortBitMap512 portmap = builder.build();
        Object[] actual = new Boolean[511];
        for (i = 0; i < 511; ++i) {
            actual[i] = false;
        }
        for (i = 0; i < 511; ++i) {
            actual[i] = portmap.isOn(OFPort.of((int)i));
        }
        Assert.assertArrayEquals((Object[])on, (Object[])actual);
        for (i = 0; i < 511; i += 7) {
            on[i] = false;
            builder.unset(OFPort.of((int)i));
        }
        portmap = builder.build();
        actual = new Boolean[511];
        for (i = 0; i < 511; ++i) {
            actual[i] = false;
        }
        for (i = 0; i < 511; ++i) {
            actual[i] = portmap.isOn(OFPort.of((int)i));
        }
        Assert.assertArrayEquals((Object[])on, (Object[])actual);
    }
}

