/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.DatapathId;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.MacAddress;

public class MacAddressTest {
    byte[][] testAddresses = new byte[][]{{1, 2, 3, 4, 5, 6}, {-128, 0, 0, 0, 0, 1}, {-1, -1, -1, -1, -1, -1}};
    String[] testColonStrings = new String[]{"01:02:03:04:05:06", "80:00:00:00:00:01", "ff:ff:ff:ff:ff:ff"};
    String[] testHyphenStrings = new String[]{"01-02-03-04-05-06", "80-00-00-00-00-01", "ff-ff-ff-ff-ff-ff"};
    long[] testInts = new long[]{1108152157446L, 0x800000000001L, 0xFFFFFFFFFFFFL};
    String[] invalidMacStrings = new String[]{"", "1.2.3.4", "0T:00:01:02:03:04", "00:01:02:03:04:05:06", "00:ff:ef:12:12:ff:", "00:fff:ef:12:12:ff", "01:02:03:04:05;06", "0:1:2:3:4:5:6", "01:02:03:04", "01-02-03:04-05-06"};
    byte[][] invalidMacBytes = new byte[][]{{1, 1, 2, 3, 4, 5, 6}, {1, 1, 2, 3, 4}};

    @Test
    public void testOfString() {
        this.testOfStringForArray(this.testColonStrings);
        this.testOfStringForArray(this.testHyphenStrings);
    }

    private void testOfStringForArray(String[] strings) {
        for (int i = 0; i < this.testAddresses.length; ++i) {
            MacAddress ip = MacAddress.of((String)strings[i]);
            Assert.assertEquals((long)this.testInts[i], (long)ip.getLong());
            Assert.assertArrayEquals((byte[])this.testAddresses[i], (byte[])ip.getBytes());
        }
    }

    @Test
    public void testOfByteArray() {
        for (int i = 0; i < this.testAddresses.length; ++i) {
            MacAddress ip = MacAddress.of((byte[])this.testAddresses[i]);
            Assert.assertEquals((String)("error checking long representation of " + Arrays.toString(this.testAddresses[i]) + "(should be " + Long.toHexString(this.testInts[i]) + ")"), (long)this.testInts[i], (long)ip.getLong());
            Assert.assertArrayEquals((byte[])this.testAddresses[i], (byte[])ip.getBytes());
            Assert.assertEquals((Object)this.testColonStrings[i], (Object)ip.toString());
        }
    }

    @Test
    public void testReadFrom() throws OFParseError {
        for (int i = 0; i < this.testAddresses.length; ++i) {
            MacAddress ip = MacAddress.read6Bytes((ByteBuf)Unpooled.copiedBuffer((byte[])this.testAddresses[i]));
            Assert.assertEquals((long)this.testInts[i], (long)ip.getLong());
            Assert.assertArrayEquals((byte[])this.testAddresses[i], (byte[])ip.getBytes());
            Assert.assertEquals((Object)this.testColonStrings[i], (Object)ip.toString());
        }
    }

    @Test
    public void testInvalidMacStrings() throws OFParseError {
        for (String invalid : this.invalidMacStrings) {
            try {
                MacAddress.of((String)invalid);
                Assert.fail((String)("Invalid MAC address " + invalid + " should have raised IllegalArgumentException"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testInvalidMacBytes() throws OFParseError {
        for (byte[] invalid : this.invalidMacBytes) {
            try {
                MacAddress.of((byte[])invalid);
                Assert.fail((String)("Invalid MAC address bytes " + Arrays.toString(invalid) + " should have raised IllegalArgumentException"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testToLong() {
        Assert.assertEquals((long)0xFFFFFFFFFFFFL, (long)MacAddress.of((byte[])new byte[]{-1, -1, -1, -1, -1, -1}).getLong());
        Assert.assertEquals((long)0x10101010101L, (long)MacAddress.of((byte[])new byte[]{1, 1, 1, 1, 1, 1}).getLong());
        Assert.assertEquals((long)0x808080808080L, (long)MacAddress.of((byte[])new byte[]{-128, -128, -128, -128, -128, -128}).getLong());
    }

    @Test
    public void testIsBroadcast() {
        Assert.assertTrue((boolean)MacAddress.of((String)"FF:FF:FF:FF:FF:FF").isBroadcast());
        Assert.assertTrue((boolean)MacAddress.of((long)-1L).isBroadcast());
        Assert.assertTrue((boolean)MacAddress.of((long)0x5FFFFFFFFFFFFL).isBroadcast());
        Assert.assertFalse((boolean)MacAddress.of((String)"11:22:33:44:55:66").isBroadcast());
    }

    @Test
    public void testIsMulticast() {
        Assert.assertTrue((boolean)MacAddress.of((String)"01:80:C2:00:00:00").isMulticast());
        Assert.assertFalse((boolean)MacAddress.of((String)"00:80:C2:00:00:00").isMulticast());
        Assert.assertFalse((boolean)MacAddress.of((String)"FE:80:C2:00:00:00").isMulticast());
        Assert.assertFalse((boolean)MacAddress.of((long)-1L).isMulticast());
        Assert.assertFalse((boolean)MacAddress.of((long)0x5FFFFFFFFFFFFL).isMulticast());
        Assert.assertFalse((boolean)MacAddress.of((String)"FF:FF:FF:FF:FF:FF").isMulticast());
    }

    @Test
    public void testIsLLDPAddress() {
        Assert.assertTrue((boolean)MacAddress.of((String)"01:80:C2:00:00:00").isLLDPAddress());
        Assert.assertTrue((boolean)MacAddress.of((String)"01:80:C2:00:00:0f").isLLDPAddress());
        Assert.assertFalse((boolean)MacAddress.of((String)"01:80:C2:00:00:50").isLLDPAddress());
        Assert.assertFalse((boolean)MacAddress.of((String)"01:80:C2:00:10:00").isLLDPAddress());
        Assert.assertFalse((boolean)MacAddress.of((String)"01:80:C2:40:00:01").isLLDPAddress());
        Assert.assertFalse((boolean)MacAddress.of((String)"00:80:C2:f0:00:00").isLLDPAddress());
        Assert.assertFalse((boolean)MacAddress.of((String)"FE:80:C2:00:00:00").isLLDPAddress());
    }

    @Test
    public void testForIPv4MulticastAddress() {
        IPv4Address ip = IPv4Address.of((String)"224.1.1.1");
        MacAddress mac = MacAddress.forIPv4MulticastAddress((IPv4Address)ip);
        MacAddress expectedMac = MacAddress.of((String)"01:00:5E:01:01:01");
        Assert.assertTrue((boolean)mac.equals((Object)expectedMac));
        ip = IPv4Address.of((String)"224.129.1.1");
        mac = MacAddress.forIPv4MulticastAddress((IPv4Address)ip);
        expectedMac = MacAddress.of((String)"01:00:5E:01:01:01");
        Assert.assertTrue((boolean)mac.equals((Object)expectedMac));
        ip = IPv4Address.of((String)"225.1.1.1");
        mac = MacAddress.forIPv4MulticastAddress((IPv4Address)ip);
        expectedMac = MacAddress.of((String)"01:00:5E:01:01:01");
        Assert.assertTrue((boolean)mac.equals((Object)expectedMac));
        ip = IPv4Address.of((String)"239.129.1.1");
        mac = MacAddress.forIPv4MulticastAddress((IPv4Address)ip);
        expectedMac = MacAddress.of((String)"01:00:5E:01:01:01");
        Assert.assertTrue((boolean)mac.equals((Object)expectedMac));
        ip = IPv4Address.of((String)"224.1.2.3");
        mac = MacAddress.forIPv4MulticastAddress((IPv4Address)ip);
        expectedMac = MacAddress.of((String)"01:00:5E:01:02:03");
        Assert.assertTrue((boolean)mac.equals((Object)expectedMac));
        ip = IPv4Address.of((String)"239.129.2.3");
        mac = MacAddress.forIPv4MulticastAddress((IPv4Address)ip);
        expectedMac = MacAddress.of((String)"01:00:5E:01:02:03");
        Assert.assertTrue((boolean)mac.equals((Object)expectedMac));
    }

    public void testOfDatapathid() {
        MacAddress mac = MacAddress.of((DatapathId)DatapathId.NONE);
        MatcherAssert.assertThat((Object)mac, (Matcher)Matchers.is((Object)MacAddress.NONE));
        for (String s : this.testColonStrings) {
            DatapathId dpid = DatapathId.of((String)("00:00:" + s));
            mac = MacAddress.of((DatapathId)dpid);
            MatcherAssert.assertThat((Object)mac, (Matcher)Matchers.is((Object)MacAddress.of((String)s)));
        }
    }

    @Test
    public void forIPv6MulticastAddr() {
        IPv6Address ip = IPv6Address.of((String)"ff02::1:ff00:0");
        MacAddress mac = MacAddress.forIPv6MulticastAddr((IPv6Address)ip);
        MacAddress expectedMac = MacAddress.of((String)"33:33:ff:00:00:00");
        Assert.assertTrue((boolean)mac.equals((Object)expectedMac));
        ip = IPv6Address.of((String)"ff02::1:ff01:0203");
        mac = MacAddress.forIPv6MulticastAddr((IPv6Address)ip);
        expectedMac = MacAddress.of((String)"33:33:ff:01:02:03");
        Assert.assertTrue((boolean)mac.equals((Object)expectedMac));
        ip = IPv6Address.of((String)"ff02::1:0102:0304");
        mac = MacAddress.forIPv6MulticastAddr((IPv6Address)ip);
        expectedMac = MacAddress.of((String)"33:33:01:02:03:04");
        Assert.assertTrue((boolean)mac.equals((Object)expectedMac));
        ip = IPv6Address.of((String)"2001::1:0102:0304");
        try {
            mac = MacAddress.forIPv6MulticastAddr((IPv6Address)ip);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

