/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.types.IPAddress;
import org.projectfloodlight.openflow.types.IPAddressWithMask;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv6Address;

public class IPAddressTest {
    @Test
    public void testOfException() {
        try {
            IPAddress.of((String)"Foobar");
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IPAddressWithMask.of((String)"Foobar");
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IPAddress.of((String)null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPAddressWithMask.of(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPAddress.of((String)null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPAddressWithMask.of(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testOfString() {
        IPAddress ip0 = IPAddress.of((String)"1.2.3.4");
        IPAddress ip1 = IPAddress.of((String)"abcd::1234");
        Assert.assertTrue((boolean)(ip0 instanceof IPv4Address));
        Assert.assertTrue((boolean)(ip1 instanceof IPv6Address));
        Assert.assertEquals((Object)ip0, (Object)IPv4Address.of((String)"1.2.3.4"));
        Assert.assertEquals((Object)ip1, (Object)IPv6Address.of((String)"abcd::1234"));
    }

    @Test
    public void testOfInetAddress() throws Exception {
        InetAddress ia0 = InetAddress.getByName("192.168.1.123");
        InetAddress ia1 = InetAddress.getByName("fd00::4321");
        IPAddress ip0 = IPAddress.of((InetAddress)ia0);
        IPAddress ip1 = IPAddress.of((InetAddress)ia1);
        Assert.assertTrue((boolean)(ip0 instanceof IPv4Address));
        Assert.assertTrue((boolean)(ip1 instanceof IPv6Address));
        Assert.assertEquals((Object)ip0, (Object)IPv4Address.of((InetAddress)ia0));
        Assert.assertEquals((Object)ip1, (Object)IPv6Address.of((InetAddress)ia1));
    }

    @Test
    public void testFromInetAddressException() throws UnknownHostException {
        try {
            IPAddress.fromInetAddress(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testToInetAddress() throws Exception {
        IPAddress ip0 = IPAddress.of((String)"201.202.3.4");
        IPAddress ip1 = IPAddress.of((String)"2001:db8:abcd::1:2:3:4");
        InetAddress ia0 = ip0.toInetAddress();
        InetAddress ia1 = ip1.toInetAddress();
        Assert.assertEquals((Object)ia0, (Object)InetAddress.getByName("201.202.3.4"));
        Assert.assertEquals((Object)ia1, (Object)InetAddress.getByName("2001:db8:abcd:0:1:2:3:4"));
    }

    @Test
    public void testContains() {
        IPAddressWithMask mask = IPAddressWithMask.of((String)"1.2.3.4/24");
        IPAddress validIp = IPAddress.of((String)"1.2.3.5");
        Assert.assertTrue((boolean)mask.contains(validIp));
        IPAddress invalidIp = IPAddress.of((String)"1.2.5.5");
        Assert.assertFalse((boolean)mask.contains(invalidIp));
        IPAddress invalidIpv6 = IPAddress.of((String)"10:10::ffff");
        Assert.assertFalse((boolean)mask.contains(invalidIpv6));
        mask = IPAddressWithMask.of((String)"10:10::1/112");
        validIp = IPAddress.of((String)"10:10::f");
        Assert.assertTrue((boolean)mask.contains(validIp));
        invalidIp = IPAddress.of((String)"11:10::f");
        Assert.assertFalse((boolean)mask.contains(invalidIp));
        IPAddress invalidIpv4 = IPAddress.of((String)"10.0.0.1");
        Assert.assertFalse((boolean)mask.contains(invalidIpv4));
    }

    @Test
    public void testContainsException() {
        try {
            IPAddressWithMask mask = IPAddressWithMask.of((String)"1.2.3.4/24");
            mask.contains(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testIsUnspecified() {
        IPAddress unspecifiedV4 = IPAddress.of((String)"0.0.0.0");
        IPAddress unspecifiedV6 = IPAddress.of((String)"::");
        MatcherAssert.assertThat((Object)unspecifiedV4.isUnspecified(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)unspecifiedV6.isUnspecified(), (Matcher)Matchers.is((Object)true));
        ImmutableList others = ImmutableList.of((Object)"0.0.0.1", (Object)"1.2.3.4", (Object)"10.0.0.0", (Object)"127.0.0.1", (Object)"255.255.255.255", (Object)"::1", (Object)"2001:db8:1:2::5:6", (Object)"fc00::4:5:6:7", (Object)"fe80::1234", (Object)"ff02::1");
        for (String other : others) {
            MatcherAssert.assertThat((Object)IPAddress.of((String)other).isUnspecified(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testIsLoopback() {
        ImmutableList loopbacks = ImmutableList.of((Object)"127.0.0.0", (Object)"127.0.0.1", (Object)"127.0.0.2", (Object)"127.0.0.255", (Object)"127.1.2.3", (Object)"127.101.102.103", (Object)"127.201.202.203", (Object)"127.255.255.255", (Object)"::1");
        for (String loopback : loopbacks) {
            MatcherAssert.assertThat((Object)IPAddress.of((String)loopback).isLoopback(), (Matcher)Matchers.is((Object)true));
        }
        ImmutableList others = ImmutableList.of((Object)"0.0.0.0", (Object)"0.0.0.1", (Object)"10.0.0.1", (Object)"126.255.255.255", (Object)"128.0.0.0", (Object)"255.255.255.255", (Object)"::", (Object)"::2", (Object)"2001:db8::1:2:3:4", (Object)"fe80:7:6:5:4:3:2:1", (Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        for (String other : others) {
            MatcherAssert.assertThat((Object)IPAddress.of((String)other).isLoopback(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testIsLinkLocal() {
        ImmutableList linkLocals = ImmutableList.of((Object)"169.254.0.0", (Object)"169.254.0.1", (Object)"169.254.1.2", (Object)"169.254.101.102", (Object)"169.254.201.202", (Object)"169.254.255.255", (Object)"fe80::", (Object)"fe80::1", (Object)"fe80::1:2:3:4:5:6:7", (Object)"fe80:aaaa:bbbb:cccc:dddd:eeee:ffff:1234", (Object)"febf::", (Object)"febf:ffff:ffff:ffff:ffff:ffff:ffff:ffff", (Object[])new String[0]);
        for (String linkLocal : linkLocals) {
            MatcherAssert.assertThat((Object)IPAddress.of((String)linkLocal).isLinkLocal(), (Matcher)Matchers.is((Object)true));
        }
        ImmutableList others = ImmutableList.of((Object)"0.0.0.0", (Object)"1.2.3.4", (Object)"169.253.255.255", (Object)"169.255.0.0", (Object)"255.255.255.255", (Object)"::", (Object)"fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff", (Object)"fec0::", (Object)"ff02::1");
        for (String other : others) {
            MatcherAssert.assertThat((Object)IPAddress.of((String)other).isLinkLocal(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testMulticastIp() {
        IPAddress ip0 = IPAddress.of((String)"240.2.3.4");
        IPAddress ip1 = IPAddress.of((String)"224.0.1.1");
        IPAddress ip2 = IPAddress.of((String)"239.0.0.0");
        IPAddress ip3 = IPAddress.of((String)"feff::1");
        IPAddress ip4 = IPAddress.of((String)"ff00::1");
        Assert.assertTrue((!ip0.isMulticast() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ip1.isMulticast());
        Assert.assertTrue((boolean)ip2.isMulticast());
        Assert.assertTrue((!ip3.isMulticast() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ip4.isMulticast());
    }
}

