/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFTableConfig;
import org.projectfloodlight.openflow.protocol.OFTableReason;
import org.projectfloodlight.openflow.protocol.OFTableStatus;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableStatusVer15;
import org.projectfloodlight.openflow.types.TableId;

public class OFTableStatusVer15Test {
    OFFactory factory;
    static final byte[] TABLE_STATUS_SERIALIZED = new byte[]{6, 31, 0, 32, 18, 52, 86, 120, 3, 0, 0, 0, 0, 0, 0, 0, 0, 16, 1, 0, 0, 0, 0, 8, 0, 3, 0, 8, 3, 4, 5, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFTableStatus.Builder builder = this.factory.buildTableStatus();
        builder.setXid(305419896L).setReason(OFTableReason.VACANCY_DOWN).setTable(this.factory.buildTableDesc().setTableId(TableId.of((int)1)).setConfig((Set)ImmutableSet.of((Object)OFTableConfig.VACANCY_EVENTS)).setProperties((List)ImmutableList.of((Object)this.factory.buildTableModPropVacancy().setVacancyDown((short)3).setVacancyUp((short)4).setVacancy((short)5).build())).build()).build();
        OFTableStatus tableStatus = builder.build();
        ByteBuf bb = Unpooled.buffer();
        tableStatus.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)TABLE_STATUS_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFTableStatus.Builder builder = this.factory.buildTableStatus();
        builder.setXid(305419896L).setReason(OFTableReason.VACANCY_DOWN).setTable(this.factory.buildTableDesc().setTableId(TableId.of((int)1)).setConfig((Set)ImmutableSet.of((Object)OFTableConfig.VACANCY_EVENTS)).setProperties((List)ImmutableList.of((Object)this.factory.buildTableModPropVacancy().setVacancyDown((short)3).setVacancyUp((short)4).setVacancy((short)5).build())).build()).build();
        OFTableStatus tableStatusBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])TABLE_STATUS_SERIALIZED);
        OFTableStatus tableStatusRead = OFTableStatusVer15.READER.readFrom(input);
        Assert.assertEquals((long)TABLE_STATUS_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)tableStatusBuilt, (Object)tableStatusRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])TABLE_STATUS_SERIALIZED);
        OFTableStatus tableStatus = OFTableStatusVer15.READER.readFrom(input);
        Assert.assertEquals((long)TABLE_STATUS_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        tableStatus.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)TABLE_STATUS_SERIALIZED));
    }
}

