/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortFeatures;
import org.projectfloodlight.openflow.protocol.OFPortMod;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortModVer15;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;

public class OFPortModVer15Test {
    OFFactory factory;
    static final byte[] PORT_MOD_SERIALIZED = new byte[]{6, 16, 0, 40, 18, 52, 86, 120, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFPortMod.Builder builder = this.factory.buildPortMod();
        builder.setXid(305419896L).setPortNo(OFPort.of((int)1)).setHwAddr(MacAddress.of((String)"00:01:02:03:04:05")).setConfig((Set)ImmutableSet.of((Object)OFPortConfig.PORT_DOWN)).setMask((Set)ImmutableSet.of((Object)OFPortConfig.PORT_DOWN)).setProperties((List)ImmutableList.of((Object)this.factory.buildPortModPropEthernet().setAdvertise((Set)ImmutableSet.of((Object)OFPortFeatures.PF_10MB_HD)).build())).build();
        OFPortMod portMod = builder.build();
        ByteBuf bb = Unpooled.buffer();
        portMod.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_MOD_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFPortMod.Builder builder = this.factory.buildPortMod();
        builder.setXid(305419896L).setPortNo(OFPort.of((int)1)).setHwAddr(MacAddress.of((String)"00:01:02:03:04:05")).setConfig((Set)ImmutableSet.of((Object)OFPortConfig.PORT_DOWN)).setMask((Set)ImmutableSet.of((Object)OFPortConfig.PORT_DOWN)).setProperties((List)ImmutableList.of((Object)this.factory.buildPortModPropEthernet().setAdvertise((Set)ImmutableSet.of((Object)OFPortFeatures.PF_10MB_HD)).build())).build();
        OFPortMod portModBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_MOD_SERIALIZED);
        OFPortMod portModRead = OFPortModVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_MOD_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)portModBuilt, (Object)portModRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_MOD_SERIALIZED);
        OFPortMod portMod = OFPortModVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_MOD_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        portMod.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_MOD_SERIALIZED));
    }
}

