/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMeterFlags;
import org.projectfloodlight.openflow.protocol.OFMeterMod;
import org.projectfloodlight.openflow.protocol.OFMeterModCommand;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterModVer15;

public class OFMeterModVer15Test {
    OFFactory factory;
    static final byte[] METER_MOD_SERIALIZED = new byte[]{6, 29, 0, 32, 18, 52, 86, 120, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 16, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFMeterMod.Builder builder = this.factory.buildMeterMod();
        builder.setXid(305419896L).setCommand(OFMeterModCommand.ADD).setFlags((Set)ImmutableSet.of((Object)OFMeterFlags.KBPS)).setMeterId(1L).setBands((List)ImmutableList.of((Object)this.factory.meterBands().buildDrop().setRate(1L).setBurstSize(2L).build())).build();
        OFMeterMod meterMod = builder.build();
        ByteBuf bb = Unpooled.buffer();
        meterMod.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)METER_MOD_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFMeterMod.Builder builder = this.factory.buildMeterMod();
        builder.setXid(305419896L).setCommand(OFMeterModCommand.ADD).setFlags((Set)ImmutableSet.of((Object)OFMeterFlags.KBPS)).setMeterId(1L).setBands((List)ImmutableList.of((Object)this.factory.meterBands().buildDrop().setRate(1L).setBurstSize(2L).build())).build();
        OFMeterMod meterModBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])METER_MOD_SERIALIZED);
        OFMeterMod meterModRead = OFMeterModVer15.READER.readFrom(input);
        Assert.assertEquals((long)METER_MOD_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)meterModBuilt, (Object)meterModRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])METER_MOD_SERIALIZED);
        OFMeterMod meterMod = OFMeterModVer15.READER.readFrom(input);
        Assert.assertEquals((long)METER_MOD_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        meterMod.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)METER_MOD_SERIALIZED));
    }
}

