/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFHelloFailedCode;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFErrorMsgs;
import org.projectfloodlight.openflow.protocol.errormsg.OFHelloFailedErrorMsg;
import org.projectfloodlight.openflow.protocol.ver15.OFErrorMsgsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFHelloFailedErrorMsgVer15;
import org.projectfloodlight.openflow.types.OFErrorCauseData;

public class OFHelloFailedErrorMsgVer15Test {
    OFErrorMsgs factory;
    static final byte[] HELLO_FAILED_ERROR_MSG_SERIALIZED = new byte[]{6, 1, 0, 15, 18, 52, 86, 120, 0, 0, 0, 0, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFErrorMsgsVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFHelloFailedErrorMsg.Builder builder = this.factory.buildHelloFailedErrorMsg();
        builder.setXid(305419896L).setCode(OFHelloFailedCode.INCOMPATIBLE).setData(OFErrorCauseData.of((byte[])new byte[]{97, 98, 99}, (OFVersion)OFVersion.OF_15));
        OFHelloFailedErrorMsg helloFailedErrorMsg = builder.build();
        ByteBuf bb = Unpooled.buffer();
        helloFailedErrorMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)HELLO_FAILED_ERROR_MSG_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFHelloFailedErrorMsg.Builder builder = this.factory.buildHelloFailedErrorMsg();
        builder.setXid(305419896L).setCode(OFHelloFailedCode.INCOMPATIBLE).setData(OFErrorCauseData.of((byte[])new byte[]{97, 98, 99}, (OFVersion)OFVersion.OF_15));
        OFHelloFailedErrorMsg helloFailedErrorMsgBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])HELLO_FAILED_ERROR_MSG_SERIALIZED);
        OFHelloFailedErrorMsg helloFailedErrorMsgRead = OFHelloFailedErrorMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)HELLO_FAILED_ERROR_MSG_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)helloFailedErrorMsgBuilt, (Object)helloFailedErrorMsgRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])HELLO_FAILED_ERROR_MSG_SERIALIZED);
        OFHelloFailedErrorMsg helloFailedErrorMsg = OFHelloFailedErrorMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)HELLO_FAILED_ERROR_MSG_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        helloFailedErrorMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)HELLO_FAILED_ERROR_MSG_SERIALIZED));
    }
}

