/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFHelloElemVersionbitmap;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFHelloElemVersionbitmapVer15;
import org.projectfloodlight.openflow.types.U32;

public class OFHelloElemVersionbitmapVer15Test {
    OFFactory factory;
    static final byte[] HELLO_ELEM_VERSIONBITMAP_SERIALIZED = new byte[]{0, 1, 0, 12, 1, 35, 69, 103, -119, -85, -51, -17};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFHelloElemVersionbitmap.Builder builder = this.factory.buildHelloElemVersionbitmap();
        builder.setBitmaps((List)ImmutableList.of((Object)U32.of((long)19088743L), (Object)U32.of((long)-1985229329L))).build();
        OFHelloElemVersionbitmap helloElemVersionbitmap = builder.build();
        ByteBuf bb = Unpooled.buffer();
        helloElemVersionbitmap.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)HELLO_ELEM_VERSIONBITMAP_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFHelloElemVersionbitmap.Builder builder = this.factory.buildHelloElemVersionbitmap();
        builder.setBitmaps((List)ImmutableList.of((Object)U32.of((long)19088743L), (Object)U32.of((long)-1985229329L))).build();
        OFHelloElemVersionbitmap helloElemVersionbitmapBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])HELLO_ELEM_VERSIONBITMAP_SERIALIZED);
        OFHelloElemVersionbitmap helloElemVersionbitmapRead = OFHelloElemVersionbitmapVer15.READER.readFrom(input);
        Assert.assertEquals((long)HELLO_ELEM_VERSIONBITMAP_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)helloElemVersionbitmapBuilt, (Object)helloElemVersionbitmapRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])HELLO_ELEM_VERSIONBITMAP_SERIALIZED);
        OFHelloElemVersionbitmap helloElemVersionbitmap = OFHelloElemVersionbitmapVer15.READER.readFrom(input);
        Assert.assertEquals((long)HELLO_ELEM_VERSIONBITMAP_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        helloElemVersionbitmap.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)HELLO_ELEM_VERSIONBITMAP_SERIALIZED));
    }
}

