/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGroupStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupStatsReplyVer15;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.U64;

public class OFGroupStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] GROUP_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 88, 18, 52, 86, 120, 0, 6, 0, 1, 0, 0, 0, 0, 0, 72, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 3, -78, -48, 94, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 10};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFGroupStatsReply.Builder builder = this.factory.buildGroupStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildGroupStatsEntry().setGroup(OFGroup.of((int)1)).setRefCount(1L).setPacketCount(U64.of((long)7L)).setByteCount(U64.of((long)18L)).setDurationSec(3L).setDurationNsec(3000000000L).setBucketStats((List)ImmutableList.of((Object)this.factory.buildBucketCounter().setPacketCount(U64.of((long)7L)).setByteCount(U64.of((long)12L)).build(), (Object)this.factory.buildBucketCounter().setPacketCount(U64.of((long)3L)).setByteCount(U64.of((long)10L)).build())).build())).build();
        OFGroupStatsReply groupStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        groupStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFGroupStatsReply.Builder builder = this.factory.buildGroupStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildGroupStatsEntry().setGroup(OFGroup.of((int)1)).setRefCount(1L).setPacketCount(U64.of((long)7L)).setByteCount(U64.of((long)18L)).setDurationSec(3L).setDurationNsec(3000000000L).setBucketStats((List)ImmutableList.of((Object)this.factory.buildBucketCounter().setPacketCount(U64.of((long)7L)).setByteCount(U64.of((long)12L)).build(), (Object)this.factory.buildBucketCounter().setPacketCount(U64.of((long)3L)).setByteCount(U64.of((long)10L)).build())).build())).build();
        OFGroupStatsReply groupStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_STATS_REPLY_SERIALIZED);
        OFGroupStatsReply groupStatsReplyRead = OFGroupStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)groupStatsReplyBuilt, (Object)groupStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_STATS_REPLY_SERIALIZED);
        OFGroupStatsReply groupStatsReply = OFGroupStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        groupStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_STATS_REPLY_SERIALIZED));
    }
}

