/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFEchoReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver15.OFEchoReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;

public class OFEchoReplyVer15Test {
    OFFactory factory;
    static final byte[] ECHO_REPLY_SERIALIZED = new byte[]{6, 3, 0, 11, 18, 52, 86, 120, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFEchoReply.Builder builder = this.factory.buildEchoReply();
        builder.setXid(305419896L).setData(new byte[]{97, 98, 99}).build();
        OFEchoReply echoReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        echoReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ECHO_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFEchoReply.Builder builder = this.factory.buildEchoReply();
        builder.setXid(305419896L).setData(new byte[]{97, 98, 99}).build();
        OFEchoReply echoReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])ECHO_REPLY_SERIALIZED);
        OFEchoReply echoReplyRead = OFEchoReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)ECHO_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)echoReplyBuilt, (Object)echoReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])ECHO_REPLY_SERIALIZED);
        OFEchoReply echoReply = OFEchoReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)ECHO_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        echoReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ECHO_REPLY_SERIALIZED));
    }
}

