/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnFlowIdle;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnFlowIdleVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class OFBsnFlowIdleVer13Test {
    OFFactory factory;
    static final byte[] BSN_FLOW_IDLE_SERIALIZED = new byte[]{4, 4, 0, 56, 18, 52, 86, 120, 0, 92, 22, -57, 0, 0, 0, 40, -2, -36, -70, -104, 118, 84, 50, 16, 66, 104, 20, 0, 0, 0, 0, 0, 0, 1, 0, 22, -128, 0, 1, 8, 0, 0, 0, 4, 0, 0, 0, 5, -128, 0, 42, 2, 0, 1, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnFlowIdle.Builder builder = this.factory.buildBsnFlowIdle();
        builder.setXid(305419896L).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setPriority(17000).setTableId(TableId.of((int)20)).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).setExact(MatchField.ARP_OP, (OFValueType)ArpOpcode.of((int)1)).build());
        OFBsnFlowIdle bsnFlowIdle = builder.build();
        ByteBuf bb = Unpooled.buffer();
        bsnFlowIdle.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_FLOW_IDLE_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnFlowIdle.Builder builder = this.factory.buildBsnFlowIdle();
        builder.setXid(305419896L).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setPriority(17000).setTableId(TableId.of((int)20)).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).setExact(MatchField.ARP_OP, (OFValueType)ArpOpcode.of((int)1)).build());
        OFBsnFlowIdle bsnFlowIdleBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BSN_FLOW_IDLE_SERIALIZED);
        OFBsnFlowIdle bsnFlowIdleRead = OFBsnFlowIdleVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_FLOW_IDLE_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnFlowIdleBuilt, (Object)bsnFlowIdleRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BSN_FLOW_IDLE_SERIALIZED);
        OFBsnFlowIdle bsnFlowIdle = OFBsnFlowIdleVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_FLOW_IDLE_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        bsnFlowIdle.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_FLOW_IDLE_SERIALIZED));
    }
}

