// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFTableFeaturePropNextTablesVer15 implements OFTableFeaturePropNextTables {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropNextTablesVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int MINIMUM_LENGTH = 4;
    // maximum OF message length: 16 bit, unsigned
    final static int MAXIMUM_LENGTH = 0xFFFF;

        private final static List<U8> DEFAULT_NEXT_TABLE_IDS = ImmutableList.<U8>of();

    // OF message fields
    private final List<U8> nextTableIds;
//
    // Immutable default instance
    final static OFTableFeaturePropNextTablesVer15 DEFAULT = new OFTableFeaturePropNextTablesVer15(
        DEFAULT_NEXT_TABLE_IDS
    );

    // package private constructor - used by readers, builders, and factory
    OFTableFeaturePropNextTablesVer15(List<U8> nextTableIds) {
        if(nextTableIds == null) {
            throw new NullPointerException("OFTableFeaturePropNextTablesVer15: property nextTableIds cannot be null");
        }
        this.nextTableIds = nextTableIds;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return 0x2;
    }

    @Override
    public List<U8> getNextTableIds() {
        return nextTableIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFTableFeaturePropNextTables.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFTableFeaturePropNextTables.Builder {
        final OFTableFeaturePropNextTablesVer15 parentMessage;

        // OF message fields
        private boolean nextTableIdsSet;
        private List<U8> nextTableIds;

        BuilderWithParent(OFTableFeaturePropNextTablesVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return 0x2;
    }

    @Override
    public List<U8> getNextTableIds() {
        return nextTableIds;
    }

    @Override
    public OFTableFeaturePropNextTables.Builder setNextTableIds(List<U8> nextTableIds) {
        this.nextTableIds = nextTableIds;
        this.nextTableIdsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFTableFeaturePropNextTables build() {
                List<U8> nextTableIds = this.nextTableIdsSet ? this.nextTableIds : parentMessage.nextTableIds;
                if(nextTableIds == null)
                    throw new NullPointerException("Property nextTableIds must not be null");

                //
                return new OFTableFeaturePropNextTablesVer15(
                    nextTableIds
                );
        }

    }

    static class Builder implements OFTableFeaturePropNextTables.Builder {
        // OF message fields
        private boolean nextTableIdsSet;
        private List<U8> nextTableIds;

    @Override
    public int getType() {
        return 0x2;
    }

    @Override
    public List<U8> getNextTableIds() {
        return nextTableIds;
    }

    @Override
    public OFTableFeaturePropNextTables.Builder setNextTableIds(List<U8> nextTableIds) {
        this.nextTableIds = nextTableIds;
        this.nextTableIdsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFTableFeaturePropNextTables build() {
            List<U8> nextTableIds = this.nextTableIdsSet ? this.nextTableIds : DEFAULT_NEXT_TABLE_IDS;
            if(nextTableIds == null)
                throw new NullPointerException("Property nextTableIds must not be null");


            return new OFTableFeaturePropNextTablesVer15(
                    nextTableIds
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFTableFeaturePropNextTables> {
        @Override
        public OFTableFeaturePropNextTables readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 0x2
            short type = bb.readShort();
            if(type != (short) 0x2)
                throw new OFParseError("Wrong type: Expected=0x2(0x2), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            List<U8> nextTableIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U8.READER);

            OFTableFeaturePropNextTablesVer15 tableFeaturePropNextTablesVer15 = new OFTableFeaturePropNextTablesVer15(
                    nextTableIds
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", tableFeaturePropNextTablesVer15);
            return tableFeaturePropNextTablesVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFTableFeaturePropNextTablesVer15Funnel FUNNEL = new OFTableFeaturePropNextTablesVer15Funnel();
    static class OFTableFeaturePropNextTablesVer15Funnel implements Funnel<OFTableFeaturePropNextTablesVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFTableFeaturePropNextTablesVer15 message, PrimitiveSink sink) {
            // fixed value property type = 0x2
            sink.putShort((short) 0x2);
            // FIXME: skip funnel of length
            FunnelUtils.putList(message.nextTableIds, sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFTableFeaturePropNextTablesVer15> {
        @Override
        public void write(ByteBuf bb, OFTableFeaturePropNextTablesVer15 message) {
            int startIndex = bb.writerIndex();
            // fixed value property type = 0x2
            bb.writeShort((short) 0x2);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            ChannelUtils.writeList(bb, message.nextTableIds);

            // update length field
            int length = bb.writerIndex() - startIndex;
            if (length > MAXIMUM_LENGTH) {
                throw new IllegalArgumentException("OFTableFeaturePropNextTablesVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropNextTablesVer15(");
        b.append("nextTableIds=").append(nextTableIds);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFTableFeaturePropNextTablesVer15 other = (OFTableFeaturePropNextTablesVer15) obj;

        if (nextTableIds == null) {
            if (other.nextTableIds != null)
                return false;
        } else if (!nextTableIds.equals(other.nextTableIds))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((nextTableIds == null) ? 0 : nextTableIds.hashCode());
        return result;
    }

}
