// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_virtual_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import io.netty.buffer.ByteBuf;

abstract class OFStatsRequestVer15 {
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int MINIMUM_LENGTH = 16;


    public final static OFStatsRequestVer15.Reader READER = new Reader();

    static class Reader implements OFMessageReader<OFStatsRequest<?>> {
        @Override
        public OFStatsRequest<?> readFrom(ByteBuf bb) throws OFParseError {
            if(bb.readableBytes() < MINIMUM_LENGTH)
                return null;
            int start = bb.readerIndex();
            // fixed value property version == 6
            byte version = bb.readByte();
            if(version != (byte) 0x6)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got="+version);
            // fixed value property type == 18
            byte type = bb.readByte();
            if(type != (byte) 0x12)
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch(statsType) {
               case (short) 0x2:
                   // discriminator value OFStatsType.AGGREGATE=2 for class OFAggregateStatsRequestVer15
                   return OFAggregateStatsRequestVer15.READER.readFrom(bb);
               case (short) 0xffff:
                   // discriminator value OFStatsType.EXPERIMENTER=65535 for class OFExperimenterStatsRequestVer15
                   return OFExperimenterStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x0:
                   // discriminator value OFStatsType.DESC=0 for class OFDescStatsRequestVer15
                   return OFDescStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x1:
                   // discriminator value OFStatsType.FLOW=1 for class OFFlowStatsRequestVer15
                   return OFFlowStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x4:
                   // discriminator value OFStatsType.PORT=4 for class OFPortStatsRequestVer15
                   return OFPortStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x5:
                   // discriminator value OFStatsType.QUEUE=5 for class OFQueueStatsRequestVer15
                   return OFQueueStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x3:
                   // discriminator value OFStatsType.TABLE=3 for class OFTableStatsRequestVer15
                   return OFTableStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x7:
                   // discriminator value OFStatsType.GROUP_DESC=7 for class OFGroupDescStatsRequestVer15
                   return OFGroupDescStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x6:
                   // discriminator value OFStatsType.GROUP=6 for class OFGroupStatsRequestVer15
                   return OFGroupStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x8:
                   // discriminator value OFStatsType.GROUP_FEATURES=8 for class OFGroupFeaturesStatsRequestVer15
                   return OFGroupFeaturesStatsRequestVer15.READER.readFrom(bb);
               case (short) 0xa:
                   // discriminator value OFStatsType.METER_CONFIG=10 for class OFMeterConfigStatsRequestVer15
                   return OFMeterConfigStatsRequestVer15.READER.readFrom(bb);
               case (short) 0xb:
                   // discriminator value OFStatsType.METER_FEATURES=11 for class OFMeterFeaturesStatsRequestVer15
                   return OFMeterFeaturesStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x9:
                   // discriminator value OFStatsType.METER=9 for class OFMeterStatsRequestVer15
                   return OFMeterStatsRequestVer15.READER.readFrom(bb);
               case (short) 0xd:
                   // discriminator value OFStatsType.PORT_DESC=13 for class OFPortDescStatsRequestVer15
                   return OFPortDescStatsRequestVer15.READER.readFrom(bb);
               case (short) 0xc:
                   // discriminator value OFStatsType.TABLE_FEATURES=12 for class OFTableFeaturesStatsRequestVer15
                   return OFTableFeaturesStatsRequestVer15.READER.readFrom(bb);
               case (short) 0xf:
                   // discriminator value OFStatsType.QUEUE_DESC=15 for class OFQueueDescStatsRequestVer15
                   return OFQueueDescStatsRequestVer15.READER.readFrom(bb);
               case (short) 0xe:
                   // discriminator value OFStatsType.TABLE_DESC=14 for class OFTableDescStatsRequestVer15
                   return OFTableDescStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x13:
                   // discriminator value OFStatsType.BUNDLE_FEATURES=19 for class OFBundleFeaturesStatsRequestVer15
                   return OFBundleFeaturesStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x12:
                   // discriminator value OFStatsType.CONTROLLER_STATUS=18 for class OFControllerStatusStatsRequestVer15
                   return OFControllerStatusStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x11:
                   // discriminator value OFStatsType.FLOW_LIGHTWEIGHT=17 for class OFFlowLightweightStatsRequestVer15
                   return OFFlowLightweightStatsRequestVer15.READER.readFrom(bb);
               case (short) 0x10:
                   // discriminator value OFStatsType.FLOW_MONITOR=16 for class OFFlowMonitorRequestVer15
                   return OFFlowMonitorRequestVer15.READER.readFrom(bb);
               default:
                   throw new OFParseError("Unknown value for discriminator statsType of class OFStatsRequestVer15: " + statsType);
            }
        }
    }
}
