// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver14;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFBsnTableChecksumStatsEntryVer14 implements OFBsnTableChecksumStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTableChecksumStatsEntryVer14.class);
    // version: 1.4
    final static byte WIRE_VERSION = 5;
    final static int LENGTH = 9;

        private final static TableId DEFAULT_TABLE_ID = TableId.ALL;
        private final static U64 DEFAULT_CHECKSUM = U64.ZERO;

    // OF message fields
    private final TableId tableId;
    private final U64 checksum;
//
    // Immutable default instance
    final static OFBsnTableChecksumStatsEntryVer14 DEFAULT = new OFBsnTableChecksumStatsEntryVer14(
        DEFAULT_TABLE_ID, DEFAULT_CHECKSUM
    );

    // package private constructor - used by readers, builders, and factory
    OFBsnTableChecksumStatsEntryVer14(TableId tableId, U64 checksum) {
        if(tableId == null) {
            throw new NullPointerException("OFBsnTableChecksumStatsEntryVer14: property tableId cannot be null");
        }
        if(checksum == null) {
            throw new NullPointerException("OFBsnTableChecksumStatsEntryVer14: property checksum cannot be null");
        }
        this.tableId = tableId;
        this.checksum = checksum;
    }

    // Accessors for OF message fields
    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public U64 getChecksum() {
        return checksum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



    public OFBsnTableChecksumStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFBsnTableChecksumStatsEntry.Builder {
        final OFBsnTableChecksumStatsEntryVer14 parentMessage;

        // OF message fields
        private boolean tableIdSet;
        private TableId tableId;
        private boolean checksumSet;
        private U64 checksum;

        BuilderWithParent(OFBsnTableChecksumStatsEntryVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public OFBsnTableChecksumStatsEntry.Builder setTableId(TableId tableId) {
        this.tableId = tableId;
        this.tableIdSet = true;
        return this;
    }
    @Override
    public U64 getChecksum() {
        return checksum;
    }

    @Override
    public OFBsnTableChecksumStatsEntry.Builder setChecksum(U64 checksum) {
        this.checksum = checksum;
        this.checksumSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



        @Override
        public OFBsnTableChecksumStatsEntry build() {
                TableId tableId = this.tableIdSet ? this.tableId : parentMessage.tableId;
                if(tableId == null)
                    throw new NullPointerException("Property tableId must not be null");
                U64 checksum = this.checksumSet ? this.checksum : parentMessage.checksum;
                if(checksum == null)
                    throw new NullPointerException("Property checksum must not be null");

                //
                return new OFBsnTableChecksumStatsEntryVer14(
                    tableId,
                    checksum
                );
        }

    }

    static class Builder implements OFBsnTableChecksumStatsEntry.Builder {
        // OF message fields
        private boolean tableIdSet;
        private TableId tableId;
        private boolean checksumSet;
        private U64 checksum;

    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public OFBsnTableChecksumStatsEntry.Builder setTableId(TableId tableId) {
        this.tableId = tableId;
        this.tableIdSet = true;
        return this;
    }
    @Override
    public U64 getChecksum() {
        return checksum;
    }

    @Override
    public OFBsnTableChecksumStatsEntry.Builder setChecksum(U64 checksum) {
        this.checksum = checksum;
        this.checksumSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

//
        @Override
        public OFBsnTableChecksumStatsEntry build() {
            TableId tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if(tableId == null)
                throw new NullPointerException("Property tableId must not be null");
            U64 checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if(checksum == null)
                throw new NullPointerException("Property checksum must not be null");


            return new OFBsnTableChecksumStatsEntryVer14(
                    tableId,
                    checksum
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFBsnTableChecksumStatsEntry> {
        @Override
        public OFBsnTableChecksumStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            TableId tableId = TableId.readByte(bb);
            U64 checksum = U64.ofRaw(bb.readLong());

            OFBsnTableChecksumStatsEntryVer14 bsnTableChecksumStatsEntryVer14 = new OFBsnTableChecksumStatsEntryVer14(
                    tableId,
                      checksum
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", bsnTableChecksumStatsEntryVer14);
            return bsnTableChecksumStatsEntryVer14;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFBsnTableChecksumStatsEntryVer14Funnel FUNNEL = new OFBsnTableChecksumStatsEntryVer14Funnel();
    static class OFBsnTableChecksumStatsEntryVer14Funnel implements Funnel<OFBsnTableChecksumStatsEntryVer14> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFBsnTableChecksumStatsEntryVer14 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            message.checksum.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFBsnTableChecksumStatsEntryVer14> {
        @Override
        public void write(ByteBuf bb, OFBsnTableChecksumStatsEntryVer14 message) {
            message.tableId.writeByte(bb);
            bb.writeLong(message.checksum.getValue());


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTableChecksumStatsEntryVer14(");
        b.append("tableId=").append(tableId);
        b.append(", ");
        b.append("checksum=").append(checksum);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFBsnTableChecksumStatsEntryVer14 other = (OFBsnTableChecksumStatsEntryVer14) obj;

        if (tableId == null) {
            if (other.tableId != null)
                return false;
        } else if (!tableId.equals(other.tableId))
            return false;
        if (checksum == null) {
            if (other.checksum != null)
                return false;
        } else if (!checksum.equals(other.checksum))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((tableId == null) ? 0 : tableId.hashCode());
        result = prime * result + ((checksum == null) ? 0 : checksum.hashCode());
        return result;
    }

}
