/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.Writeable;
import org.projectfloodlight.openflow.types.OFValueType;

public final class U16
implements Writeable,
OFValueType<U16> {
    private static final short ZERO_VAL = 0;
    public static final U16 ZERO = new U16(0);
    private static final short NO_MASK_VAL = -1;
    public static final U16 NO_MASK = new U16(-1);
    public static final U16 FULL_MASK = ZERO;
    private final short raw;
    public static final Reader READER = new Reader();

    public static int f(short i) {
        return i & 0xFFFF;
    }

    public static short t(int l) {
        return (short)l;
    }

    public static int normalize(int value) {
        return value & 0xFFFF;
    }

    private U16(short raw) {
        this.raw = raw;
    }

    public static U16 of(int value) {
        return U16.ofRaw(U16.t(value));
    }

    public static U16 ofRaw(short raw) {
        if (raw == 0) {
            return ZERO;
        }
        return new U16(raw);
    }

    public int getValue() {
        return U16.f(this.raw);
    }

    public short getRaw() {
        return this.raw;
    }

    public String toString() {
        return String.format("0x%04x", this.raw);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.raw;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        U16 other = (U16)obj;
        return this.raw == other.raw;
    }

    @Override
    public void writeTo(ByteBuf bb) {
        bb.writeShort((int)this.raw);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public U16 applyMask(U16 mask) {
        return U16.ofRaw((short)(this.raw & mask.raw));
    }

    @Override
    public int compareTo(U16 o) {
        return Ints.compare((int)U16.f(this.raw), (int)U16.f(o.raw));
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putShort(this.raw);
    }

    private static class Reader
    implements OFMessageReader<U16> {
        private Reader() {
        }

        @Override
        public U16 readFrom(ByteBuf bb) throws OFParseError {
            return U16.ofRaw(bb.readShort());
        }
    }
}

