/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortStatsPropExperimenterIntel;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatsPropExperimenterIntelVer15
implements OFPortStatsPropExperimenterIntel {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatsPropExperimenterIntelVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 184;
    private static final U64 DEFAULT_RX_1_TO_64_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_RX_65_TO_127_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_RX_128_TO_255_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_RX_256_TO_511_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_RX_512_TO_1023_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_RX_1024_TO_1522_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_RX_1523_TO_MAX_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_1_TO_64_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_65_TO_127_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_128_TO_255_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_256_TO_511_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_512_TO_1023_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_1024_TO_1522_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_1523_TO_MAX_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_MULTICAST_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_RX_BROADCAST_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_BROADCAST_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_RX_UNDERSIZED_ERRORS = U64.ZERO;
    private static final U64 DEFAULT_RX_OVERSIZE_ERRORS = U64.ZERO;
    private static final U64 DEFAULT_RX_FRAGMENTED_ERRORS = U64.ZERO;
    private static final U64 DEFAULT_RX_JABBER_ERRORS = U64.ZERO;
    private final U64 rx1To64Packets;
    private final U64 rx65To127Packets;
    private final U64 rx128To255Packets;
    private final U64 rx256To511Packets;
    private final U64 rx512To1023Packets;
    private final U64 rx1024To1522Packets;
    private final U64 rx1523ToMaxPackets;
    private final U64 tx1To64Packets;
    private final U64 tx65To127Packets;
    private final U64 tx128To255Packets;
    private final U64 tx256To511Packets;
    private final U64 tx512To1023Packets;
    private final U64 tx1024To1522Packets;
    private final U64 tx1523ToMaxPackets;
    private final U64 txMulticastPackets;
    private final U64 rxBroadcastPackets;
    private final U64 txBroadcastPackets;
    private final U64 rxUndersizedErrors;
    private final U64 rxOversizeErrors;
    private final U64 rxFragmentedErrors;
    private final U64 rxJabberErrors;
    static final OFPortStatsPropExperimenterIntelVer15 DEFAULT = new OFPortStatsPropExperimenterIntelVer15(DEFAULT_RX_1_TO_64_PACKETS, DEFAULT_RX_65_TO_127_PACKETS, DEFAULT_RX_128_TO_255_PACKETS, DEFAULT_RX_256_TO_511_PACKETS, DEFAULT_RX_512_TO_1023_PACKETS, DEFAULT_RX_1024_TO_1522_PACKETS, DEFAULT_RX_1523_TO_MAX_PACKETS, DEFAULT_TX_1_TO_64_PACKETS, DEFAULT_TX_65_TO_127_PACKETS, DEFAULT_TX_128_TO_255_PACKETS, DEFAULT_TX_256_TO_511_PACKETS, DEFAULT_TX_512_TO_1023_PACKETS, DEFAULT_TX_1024_TO_1522_PACKETS, DEFAULT_TX_1523_TO_MAX_PACKETS, DEFAULT_TX_MULTICAST_PACKETS, DEFAULT_RX_BROADCAST_PACKETS, DEFAULT_TX_BROADCAST_PACKETS, DEFAULT_RX_UNDERSIZED_ERRORS, DEFAULT_RX_OVERSIZE_ERRORS, DEFAULT_RX_FRAGMENTED_ERRORS, DEFAULT_RX_JABBER_ERRORS);
    static final Reader READER = new Reader();
    static final OFPortStatsPropExperimenterIntelVer15Funnel FUNNEL = new OFPortStatsPropExperimenterIntelVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatsPropExperimenterIntelVer15(U64 rx1To64Packets, U64 rx65To127Packets, U64 rx128To255Packets, U64 rx256To511Packets, U64 rx512To1023Packets, U64 rx1024To1522Packets, U64 rx1523ToMaxPackets, U64 tx1To64Packets, U64 tx65To127Packets, U64 tx128To255Packets, U64 tx256To511Packets, U64 tx512To1023Packets, U64 tx1024To1522Packets, U64 tx1523ToMaxPackets, U64 txMulticastPackets, U64 rxBroadcastPackets, U64 txBroadcastPackets, U64 rxUndersizedErrors, U64 rxOversizeErrors, U64 rxFragmentedErrors, U64 rxJabberErrors) {
        if (rx1To64Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx1To64Packets cannot be null");
        }
        if (rx65To127Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx65To127Packets cannot be null");
        }
        if (rx128To255Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx128To255Packets cannot be null");
        }
        if (rx256To511Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx256To511Packets cannot be null");
        }
        if (rx512To1023Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx512To1023Packets cannot be null");
        }
        if (rx1024To1522Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx1024To1522Packets cannot be null");
        }
        if (rx1523ToMaxPackets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx1523ToMaxPackets cannot be null");
        }
        if (tx1To64Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx1To64Packets cannot be null");
        }
        if (tx65To127Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx65To127Packets cannot be null");
        }
        if (tx128To255Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx128To255Packets cannot be null");
        }
        if (tx256To511Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx256To511Packets cannot be null");
        }
        if (tx512To1023Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx512To1023Packets cannot be null");
        }
        if (tx1024To1522Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx1024To1522Packets cannot be null");
        }
        if (tx1523ToMaxPackets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx1523ToMaxPackets cannot be null");
        }
        if (txMulticastPackets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property txMulticastPackets cannot be null");
        }
        if (rxBroadcastPackets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rxBroadcastPackets cannot be null");
        }
        if (txBroadcastPackets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property txBroadcastPackets cannot be null");
        }
        if (rxUndersizedErrors == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rxUndersizedErrors cannot be null");
        }
        if (rxOversizeErrors == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rxOversizeErrors cannot be null");
        }
        if (rxFragmentedErrors == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rxFragmentedErrors cannot be null");
        }
        if (rxJabberErrors == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rxJabberErrors cannot be null");
        }
        this.rx1To64Packets = rx1To64Packets;
        this.rx65To127Packets = rx65To127Packets;
        this.rx128To255Packets = rx128To255Packets;
        this.rx256To511Packets = rx256To511Packets;
        this.rx512To1023Packets = rx512To1023Packets;
        this.rx1024To1522Packets = rx1024To1522Packets;
        this.rx1523ToMaxPackets = rx1523ToMaxPackets;
        this.tx1To64Packets = tx1To64Packets;
        this.tx65To127Packets = tx65To127Packets;
        this.tx128To255Packets = tx128To255Packets;
        this.tx256To511Packets = tx256To511Packets;
        this.tx512To1023Packets = tx512To1023Packets;
        this.tx1024To1522Packets = tx1024To1522Packets;
        this.tx1523ToMaxPackets = tx1523ToMaxPackets;
        this.txMulticastPackets = txMulticastPackets;
        this.rxBroadcastPackets = rxBroadcastPackets;
        this.txBroadcastPackets = txBroadcastPackets;
        this.rxUndersizedErrors = rxUndersizedErrors;
        this.rxOversizeErrors = rxOversizeErrors;
        this.rxFragmentedErrors = rxFragmentedErrors;
        this.rxJabberErrors = rxJabberErrors;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 43521L;
    }

    @Override
    public long getExpType() {
        return 1L;
    }

    @Override
    public U64 getRx1To64Packets() {
        return this.rx1To64Packets;
    }

    @Override
    public U64 getRx65To127Packets() {
        return this.rx65To127Packets;
    }

    @Override
    public U64 getRx128To255Packets() {
        return this.rx128To255Packets;
    }

    @Override
    public U64 getRx256To511Packets() {
        return this.rx256To511Packets;
    }

    @Override
    public U64 getRx512To1023Packets() {
        return this.rx512To1023Packets;
    }

    @Override
    public U64 getRx1024To1522Packets() {
        return this.rx1024To1522Packets;
    }

    @Override
    public U64 getRx1523ToMaxPackets() {
        return this.rx1523ToMaxPackets;
    }

    @Override
    public U64 getTx1To64Packets() {
        return this.tx1To64Packets;
    }

    @Override
    public U64 getTx65To127Packets() {
        return this.tx65To127Packets;
    }

    @Override
    public U64 getTx128To255Packets() {
        return this.tx128To255Packets;
    }

    @Override
    public U64 getTx256To511Packets() {
        return this.tx256To511Packets;
    }

    @Override
    public U64 getTx512To1023Packets() {
        return this.tx512To1023Packets;
    }

    @Override
    public U64 getTx1024To1522Packets() {
        return this.tx1024To1522Packets;
    }

    @Override
    public U64 getTx1523ToMaxPackets() {
        return this.tx1523ToMaxPackets;
    }

    @Override
    public U64 getTxMulticastPackets() {
        return this.txMulticastPackets;
    }

    @Override
    public U64 getRxBroadcastPackets() {
        return this.rxBroadcastPackets;
    }

    @Override
    public U64 getTxBroadcastPackets() {
        return this.txBroadcastPackets;
    }

    @Override
    public U64 getRxUndersizedErrors() {
        return this.rxUndersizedErrors;
    }

    @Override
    public U64 getRxOversizeErrors() {
        return this.rxOversizeErrors;
    }

    @Override
    public U64 getRxFragmentedErrors() {
        return this.rxFragmentedErrors;
    }

    @Override
    public U64 getRxJabberErrors() {
        return this.rxJabberErrors;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatsPropExperimenterIntelVer15(");
        b.append("rx1To64Packets=").append(this.rx1To64Packets);
        b.append(", ");
        b.append("rx65To127Packets=").append(this.rx65To127Packets);
        b.append(", ");
        b.append("rx128To255Packets=").append(this.rx128To255Packets);
        b.append(", ");
        b.append("rx256To511Packets=").append(this.rx256To511Packets);
        b.append(", ");
        b.append("rx512To1023Packets=").append(this.rx512To1023Packets);
        b.append(", ");
        b.append("rx1024To1522Packets=").append(this.rx1024To1522Packets);
        b.append(", ");
        b.append("rx1523ToMaxPackets=").append(this.rx1523ToMaxPackets);
        b.append(", ");
        b.append("tx1To64Packets=").append(this.tx1To64Packets);
        b.append(", ");
        b.append("tx65To127Packets=").append(this.tx65To127Packets);
        b.append(", ");
        b.append("tx128To255Packets=").append(this.tx128To255Packets);
        b.append(", ");
        b.append("tx256To511Packets=").append(this.tx256To511Packets);
        b.append(", ");
        b.append("tx512To1023Packets=").append(this.tx512To1023Packets);
        b.append(", ");
        b.append("tx1024To1522Packets=").append(this.tx1024To1522Packets);
        b.append(", ");
        b.append("tx1523ToMaxPackets=").append(this.tx1523ToMaxPackets);
        b.append(", ");
        b.append("txMulticastPackets=").append(this.txMulticastPackets);
        b.append(", ");
        b.append("rxBroadcastPackets=").append(this.rxBroadcastPackets);
        b.append(", ");
        b.append("txBroadcastPackets=").append(this.txBroadcastPackets);
        b.append(", ");
        b.append("rxUndersizedErrors=").append(this.rxUndersizedErrors);
        b.append(", ");
        b.append("rxOversizeErrors=").append(this.rxOversizeErrors);
        b.append(", ");
        b.append("rxFragmentedErrors=").append(this.rxFragmentedErrors);
        b.append(", ");
        b.append("rxJabberErrors=").append(this.rxJabberErrors);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatsPropExperimenterIntelVer15 other = (OFPortStatsPropExperimenterIntelVer15)obj;
        if (this.rx1To64Packets == null ? other.rx1To64Packets != null : !this.rx1To64Packets.equals(other.rx1To64Packets)) {
            return false;
        }
        if (this.rx65To127Packets == null ? other.rx65To127Packets != null : !this.rx65To127Packets.equals(other.rx65To127Packets)) {
            return false;
        }
        if (this.rx128To255Packets == null ? other.rx128To255Packets != null : !this.rx128To255Packets.equals(other.rx128To255Packets)) {
            return false;
        }
        if (this.rx256To511Packets == null ? other.rx256To511Packets != null : !this.rx256To511Packets.equals(other.rx256To511Packets)) {
            return false;
        }
        if (this.rx512To1023Packets == null ? other.rx512To1023Packets != null : !this.rx512To1023Packets.equals(other.rx512To1023Packets)) {
            return false;
        }
        if (this.rx1024To1522Packets == null ? other.rx1024To1522Packets != null : !this.rx1024To1522Packets.equals(other.rx1024To1522Packets)) {
            return false;
        }
        if (this.rx1523ToMaxPackets == null ? other.rx1523ToMaxPackets != null : !this.rx1523ToMaxPackets.equals(other.rx1523ToMaxPackets)) {
            return false;
        }
        if (this.tx1To64Packets == null ? other.tx1To64Packets != null : !this.tx1To64Packets.equals(other.tx1To64Packets)) {
            return false;
        }
        if (this.tx65To127Packets == null ? other.tx65To127Packets != null : !this.tx65To127Packets.equals(other.tx65To127Packets)) {
            return false;
        }
        if (this.tx128To255Packets == null ? other.tx128To255Packets != null : !this.tx128To255Packets.equals(other.tx128To255Packets)) {
            return false;
        }
        if (this.tx256To511Packets == null ? other.tx256To511Packets != null : !this.tx256To511Packets.equals(other.tx256To511Packets)) {
            return false;
        }
        if (this.tx512To1023Packets == null ? other.tx512To1023Packets != null : !this.tx512To1023Packets.equals(other.tx512To1023Packets)) {
            return false;
        }
        if (this.tx1024To1522Packets == null ? other.tx1024To1522Packets != null : !this.tx1024To1522Packets.equals(other.tx1024To1522Packets)) {
            return false;
        }
        if (this.tx1523ToMaxPackets == null ? other.tx1523ToMaxPackets != null : !this.tx1523ToMaxPackets.equals(other.tx1523ToMaxPackets)) {
            return false;
        }
        if (this.txMulticastPackets == null ? other.txMulticastPackets != null : !this.txMulticastPackets.equals(other.txMulticastPackets)) {
            return false;
        }
        if (this.rxBroadcastPackets == null ? other.rxBroadcastPackets != null : !this.rxBroadcastPackets.equals(other.rxBroadcastPackets)) {
            return false;
        }
        if (this.txBroadcastPackets == null ? other.txBroadcastPackets != null : !this.txBroadcastPackets.equals(other.txBroadcastPackets)) {
            return false;
        }
        if (this.rxUndersizedErrors == null ? other.rxUndersizedErrors != null : !this.rxUndersizedErrors.equals(other.rxUndersizedErrors)) {
            return false;
        }
        if (this.rxOversizeErrors == null ? other.rxOversizeErrors != null : !this.rxOversizeErrors.equals(other.rxOversizeErrors)) {
            return false;
        }
        if (this.rxFragmentedErrors == null ? other.rxFragmentedErrors != null : !this.rxFragmentedErrors.equals(other.rxFragmentedErrors)) {
            return false;
        }
        return !(this.rxJabberErrors == null ? other.rxJabberErrors != null : !this.rxJabberErrors.equals(other.rxJabberErrors));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rx1To64Packets == null ? 0 : this.rx1To64Packets.hashCode());
        result = 31 * result + (this.rx65To127Packets == null ? 0 : this.rx65To127Packets.hashCode());
        result = 31 * result + (this.rx128To255Packets == null ? 0 : this.rx128To255Packets.hashCode());
        result = 31 * result + (this.rx256To511Packets == null ? 0 : this.rx256To511Packets.hashCode());
        result = 31 * result + (this.rx512To1023Packets == null ? 0 : this.rx512To1023Packets.hashCode());
        result = 31 * result + (this.rx1024To1522Packets == null ? 0 : this.rx1024To1522Packets.hashCode());
        result = 31 * result + (this.rx1523ToMaxPackets == null ? 0 : this.rx1523ToMaxPackets.hashCode());
        result = 31 * result + (this.tx1To64Packets == null ? 0 : this.tx1To64Packets.hashCode());
        result = 31 * result + (this.tx65To127Packets == null ? 0 : this.tx65To127Packets.hashCode());
        result = 31 * result + (this.tx128To255Packets == null ? 0 : this.tx128To255Packets.hashCode());
        result = 31 * result + (this.tx256To511Packets == null ? 0 : this.tx256To511Packets.hashCode());
        result = 31 * result + (this.tx512To1023Packets == null ? 0 : this.tx512To1023Packets.hashCode());
        result = 31 * result + (this.tx1024To1522Packets == null ? 0 : this.tx1024To1522Packets.hashCode());
        result = 31 * result + (this.tx1523ToMaxPackets == null ? 0 : this.tx1523ToMaxPackets.hashCode());
        result = 31 * result + (this.txMulticastPackets == null ? 0 : this.txMulticastPackets.hashCode());
        result = 31 * result + (this.rxBroadcastPackets == null ? 0 : this.rxBroadcastPackets.hashCode());
        result = 31 * result + (this.txBroadcastPackets == null ? 0 : this.txBroadcastPackets.hashCode());
        result = 31 * result + (this.rxUndersizedErrors == null ? 0 : this.rxUndersizedErrors.hashCode());
        result = 31 * result + (this.rxOversizeErrors == null ? 0 : this.rxOversizeErrors.hashCode());
        result = 31 * result + (this.rxFragmentedErrors == null ? 0 : this.rxFragmentedErrors.hashCode());
        result = 31 * result + (this.rxJabberErrors == null ? 0 : this.rxJabberErrors.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatsPropExperimenterIntelVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortStatsPropExperimenterIntelVer15 message) {
            bb.writeShort(-1);
            bb.writeShort(184);
            bb.writeInt(43521);
            bb.writeInt(1);
            bb.writeZero(4);
            bb.writeLong(message.rx1To64Packets.getValue());
            bb.writeLong(message.rx65To127Packets.getValue());
            bb.writeLong(message.rx128To255Packets.getValue());
            bb.writeLong(message.rx256To511Packets.getValue());
            bb.writeLong(message.rx512To1023Packets.getValue());
            bb.writeLong(message.rx1024To1522Packets.getValue());
            bb.writeLong(message.rx1523ToMaxPackets.getValue());
            bb.writeLong(message.tx1To64Packets.getValue());
            bb.writeLong(message.tx65To127Packets.getValue());
            bb.writeLong(message.tx128To255Packets.getValue());
            bb.writeLong(message.tx256To511Packets.getValue());
            bb.writeLong(message.tx512To1023Packets.getValue());
            bb.writeLong(message.tx1024To1522Packets.getValue());
            bb.writeLong(message.tx1523ToMaxPackets.getValue());
            bb.writeLong(message.txMulticastPackets.getValue());
            bb.writeLong(message.rxBroadcastPackets.getValue());
            bb.writeLong(message.txBroadcastPackets.getValue());
            bb.writeLong(message.rxUndersizedErrors.getValue());
            bb.writeLong(message.rxOversizeErrors.getValue());
            bb.writeLong(message.rxFragmentedErrors.getValue());
            bb.writeLong(message.rxJabberErrors.getValue());
        }
    }

    static class OFPortStatsPropExperimenterIntelVer15Funnel
    implements Funnel<OFPortStatsPropExperimenterIntelVer15> {
        private static final long serialVersionUID = 1L;

        OFPortStatsPropExperimenterIntelVer15Funnel() {
        }

        public void funnel(OFPortStatsPropExperimenterIntelVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)184);
            sink.putInt(43521);
            sink.putInt(1);
            message.rx1To64Packets.putTo(sink);
            message.rx65To127Packets.putTo(sink);
            message.rx128To255Packets.putTo(sink);
            message.rx256To511Packets.putTo(sink);
            message.rx512To1023Packets.putTo(sink);
            message.rx1024To1522Packets.putTo(sink);
            message.rx1523ToMaxPackets.putTo(sink);
            message.tx1To64Packets.putTo(sink);
            message.tx65To127Packets.putTo(sink);
            message.tx128To255Packets.putTo(sink);
            message.tx256To511Packets.putTo(sink);
            message.tx512To1023Packets.putTo(sink);
            message.tx1024To1522Packets.putTo(sink);
            message.tx1523ToMaxPackets.putTo(sink);
            message.txMulticastPackets.putTo(sink);
            message.rxBroadcastPackets.putTo(sink);
            message.txBroadcastPackets.putTo(sink);
            message.rxUndersizedErrors.putTo(sink);
            message.rxOversizeErrors.putTo(sink);
            message.rxFragmentedErrors.putTo(sink);
            message.rxJabberErrors.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatsPropExperimenterIntel> {
        Reader() {
        }

        @Override
        public OFPortStatsPropExperimenterIntel readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 184) {
                throw new OFParseError("Wrong length: Expected=184(184), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 43521) {
                throw new OFParseError("Wrong experimenter: Expected=0xaa01L(0xaa01L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 1) {
                throw new OFParseError("Wrong expType: Expected=0x1L(0x1L), got=" + expType);
            }
            bb.skipBytes(4);
            U64 rx1To64Packets = U64.ofRaw(bb.readLong());
            U64 rx65To127Packets = U64.ofRaw(bb.readLong());
            U64 rx128To255Packets = U64.ofRaw(bb.readLong());
            U64 rx256To511Packets = U64.ofRaw(bb.readLong());
            U64 rx512To1023Packets = U64.ofRaw(bb.readLong());
            U64 rx1024To1522Packets = U64.ofRaw(bb.readLong());
            U64 rx1523ToMaxPackets = U64.ofRaw(bb.readLong());
            U64 tx1To64Packets = U64.ofRaw(bb.readLong());
            U64 tx65To127Packets = U64.ofRaw(bb.readLong());
            U64 tx128To255Packets = U64.ofRaw(bb.readLong());
            U64 tx256To511Packets = U64.ofRaw(bb.readLong());
            U64 tx512To1023Packets = U64.ofRaw(bb.readLong());
            U64 tx1024To1522Packets = U64.ofRaw(bb.readLong());
            U64 tx1523ToMaxPackets = U64.ofRaw(bb.readLong());
            U64 txMulticastPackets = U64.ofRaw(bb.readLong());
            U64 rxBroadcastPackets = U64.ofRaw(bb.readLong());
            U64 txBroadcastPackets = U64.ofRaw(bb.readLong());
            U64 rxUndersizedErrors = U64.ofRaw(bb.readLong());
            U64 rxOversizeErrors = U64.ofRaw(bb.readLong());
            U64 rxFragmentedErrors = U64.ofRaw(bb.readLong());
            U64 rxJabberErrors = U64.ofRaw(bb.readLong());
            OFPortStatsPropExperimenterIntelVer15 portStatsPropExperimenterIntelVer15 = new OFPortStatsPropExperimenterIntelVer15(rx1To64Packets, rx65To127Packets, rx128To255Packets, rx256To511Packets, rx512To1023Packets, rx1024To1522Packets, rx1523ToMaxPackets, tx1To64Packets, tx65To127Packets, tx128To255Packets, tx256To511Packets, tx512To1023Packets, tx1024To1522Packets, tx1523ToMaxPackets, txMulticastPackets, rxBroadcastPackets, txBroadcastPackets, rxUndersizedErrors, rxOversizeErrors, rxFragmentedErrors, rxJabberErrors);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatsPropExperimenterIntelVer15);
            }
            return portStatsPropExperimenterIntelVer15;
        }
    }

    static class Builder
    implements OFPortStatsPropExperimenterIntel.Builder {
        private boolean rx1To64PacketsSet;
        private U64 rx1To64Packets;
        private boolean rx65To127PacketsSet;
        private U64 rx65To127Packets;
        private boolean rx128To255PacketsSet;
        private U64 rx128To255Packets;
        private boolean rx256To511PacketsSet;
        private U64 rx256To511Packets;
        private boolean rx512To1023PacketsSet;
        private U64 rx512To1023Packets;
        private boolean rx1024To1522PacketsSet;
        private U64 rx1024To1522Packets;
        private boolean rx1523ToMaxPacketsSet;
        private U64 rx1523ToMaxPackets;
        private boolean tx1To64PacketsSet;
        private U64 tx1To64Packets;
        private boolean tx65To127PacketsSet;
        private U64 tx65To127Packets;
        private boolean tx128To255PacketsSet;
        private U64 tx128To255Packets;
        private boolean tx256To511PacketsSet;
        private U64 tx256To511Packets;
        private boolean tx512To1023PacketsSet;
        private U64 tx512To1023Packets;
        private boolean tx1024To1522PacketsSet;
        private U64 tx1024To1522Packets;
        private boolean tx1523ToMaxPacketsSet;
        private U64 tx1523ToMaxPackets;
        private boolean txMulticastPacketsSet;
        private U64 txMulticastPackets;
        private boolean rxBroadcastPacketsSet;
        private U64 rxBroadcastPackets;
        private boolean txBroadcastPacketsSet;
        private U64 txBroadcastPackets;
        private boolean rxUndersizedErrorsSet;
        private U64 rxUndersizedErrors;
        private boolean rxOversizeErrorsSet;
        private U64 rxOversizeErrors;
        private boolean rxFragmentedErrorsSet;
        private U64 rxFragmentedErrors;
        private boolean rxJabberErrorsSet;
        private U64 rxJabberErrors;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 43521L;
        }

        @Override
        public long getExpType() {
            return 1L;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public U64 getRx1To64Packets() {
            return this.rx1To64Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx1To64Packets(U64 rx1To64Packets) {
            this.rx1To64Packets = rx1To64Packets;
            this.rx1To64PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx65To127Packets() {
            return this.rx65To127Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx65To127Packets(U64 rx65To127Packets) {
            this.rx65To127Packets = rx65To127Packets;
            this.rx65To127PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx128To255Packets() {
            return this.rx128To255Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx128To255Packets(U64 rx128To255Packets) {
            this.rx128To255Packets = rx128To255Packets;
            this.rx128To255PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx256To511Packets() {
            return this.rx256To511Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx256To511Packets(U64 rx256To511Packets) {
            this.rx256To511Packets = rx256To511Packets;
            this.rx256To511PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx512To1023Packets() {
            return this.rx512To1023Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx512To1023Packets(U64 rx512To1023Packets) {
            this.rx512To1023Packets = rx512To1023Packets;
            this.rx512To1023PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx1024To1522Packets() {
            return this.rx1024To1522Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx1024To1522Packets(U64 rx1024To1522Packets) {
            this.rx1024To1522Packets = rx1024To1522Packets;
            this.rx1024To1522PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx1523ToMaxPackets() {
            return this.rx1523ToMaxPackets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx1523ToMaxPackets(U64 rx1523ToMaxPackets) {
            this.rx1523ToMaxPackets = rx1523ToMaxPackets;
            this.rx1523ToMaxPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx1To64Packets() {
            return this.tx1To64Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx1To64Packets(U64 tx1To64Packets) {
            this.tx1To64Packets = tx1To64Packets;
            this.tx1To64PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx65To127Packets() {
            return this.tx65To127Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx65To127Packets(U64 tx65To127Packets) {
            this.tx65To127Packets = tx65To127Packets;
            this.tx65To127PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx128To255Packets() {
            return this.tx128To255Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx128To255Packets(U64 tx128To255Packets) {
            this.tx128To255Packets = tx128To255Packets;
            this.tx128To255PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx256To511Packets() {
            return this.tx256To511Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx256To511Packets(U64 tx256To511Packets) {
            this.tx256To511Packets = tx256To511Packets;
            this.tx256To511PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx512To1023Packets() {
            return this.tx512To1023Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx512To1023Packets(U64 tx512To1023Packets) {
            this.tx512To1023Packets = tx512To1023Packets;
            this.tx512To1023PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx1024To1522Packets() {
            return this.tx1024To1522Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx1024To1522Packets(U64 tx1024To1522Packets) {
            this.tx1024To1522Packets = tx1024To1522Packets;
            this.tx1024To1522PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx1523ToMaxPackets() {
            return this.tx1523ToMaxPackets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx1523ToMaxPackets(U64 tx1523ToMaxPackets) {
            this.tx1523ToMaxPackets = tx1523ToMaxPackets;
            this.tx1523ToMaxPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxMulticastPackets() {
            return this.txMulticastPackets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTxMulticastPackets(U64 txMulticastPackets) {
            this.txMulticastPackets = txMulticastPackets;
            this.txMulticastPacketsSet = true;
            return this;
        }

        @Override
        public U64 getRxBroadcastPackets() {
            return this.rxBroadcastPackets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRxBroadcastPackets(U64 rxBroadcastPackets) {
            this.rxBroadcastPackets = rxBroadcastPackets;
            this.rxBroadcastPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxBroadcastPackets() {
            return this.txBroadcastPackets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTxBroadcastPackets(U64 txBroadcastPackets) {
            this.txBroadcastPackets = txBroadcastPackets;
            this.txBroadcastPacketsSet = true;
            return this;
        }

        @Override
        public U64 getRxUndersizedErrors() {
            return this.rxUndersizedErrors;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRxUndersizedErrors(U64 rxUndersizedErrors) {
            this.rxUndersizedErrors = rxUndersizedErrors;
            this.rxUndersizedErrorsSet = true;
            return this;
        }

        @Override
        public U64 getRxOversizeErrors() {
            return this.rxOversizeErrors;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRxOversizeErrors(U64 rxOversizeErrors) {
            this.rxOversizeErrors = rxOversizeErrors;
            this.rxOversizeErrorsSet = true;
            return this;
        }

        @Override
        public U64 getRxFragmentedErrors() {
            return this.rxFragmentedErrors;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRxFragmentedErrors(U64 rxFragmentedErrors) {
            this.rxFragmentedErrors = rxFragmentedErrors;
            this.rxFragmentedErrorsSet = true;
            return this;
        }

        @Override
        public U64 getRxJabberErrors() {
            return this.rxJabberErrors;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRxJabberErrors(U64 rxJabberErrors) {
            this.rxJabberErrors = rxJabberErrors;
            this.rxJabberErrorsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortStatsPropExperimenterIntel build() {
            U64 rxJabberErrors;
            U64 rxFragmentedErrors;
            U64 rxOversizeErrors;
            U64 rxUndersizedErrors;
            U64 txBroadcastPackets;
            U64 rxBroadcastPackets;
            U64 txMulticastPackets;
            U64 tx1523ToMaxPackets;
            U64 tx1024To1522Packets;
            U64 tx512To1023Packets;
            U64 tx256To511Packets;
            U64 tx128To255Packets;
            U64 tx65To127Packets;
            U64 tx1To64Packets;
            U64 rx1523ToMaxPackets;
            U64 rx1024To1522Packets;
            U64 rx512To1023Packets;
            U64 rx256To511Packets;
            U64 rx128To255Packets;
            U64 rx65To127Packets;
            U64 rx1To64Packets;
            U64 u64 = rx1To64Packets = this.rx1To64PacketsSet ? this.rx1To64Packets : DEFAULT_RX_1_TO_64_PACKETS;
            if (rx1To64Packets == null) {
                throw new NullPointerException("Property rx1To64Packets must not be null");
            }
            U64 u642 = rx65To127Packets = this.rx65To127PacketsSet ? this.rx65To127Packets : DEFAULT_RX_65_TO_127_PACKETS;
            if (rx65To127Packets == null) {
                throw new NullPointerException("Property rx65To127Packets must not be null");
            }
            U64 u643 = rx128To255Packets = this.rx128To255PacketsSet ? this.rx128To255Packets : DEFAULT_RX_128_TO_255_PACKETS;
            if (rx128To255Packets == null) {
                throw new NullPointerException("Property rx128To255Packets must not be null");
            }
            U64 u644 = rx256To511Packets = this.rx256To511PacketsSet ? this.rx256To511Packets : DEFAULT_RX_256_TO_511_PACKETS;
            if (rx256To511Packets == null) {
                throw new NullPointerException("Property rx256To511Packets must not be null");
            }
            U64 u645 = rx512To1023Packets = this.rx512To1023PacketsSet ? this.rx512To1023Packets : DEFAULT_RX_512_TO_1023_PACKETS;
            if (rx512To1023Packets == null) {
                throw new NullPointerException("Property rx512To1023Packets must not be null");
            }
            U64 u646 = rx1024To1522Packets = this.rx1024To1522PacketsSet ? this.rx1024To1522Packets : DEFAULT_RX_1024_TO_1522_PACKETS;
            if (rx1024To1522Packets == null) {
                throw new NullPointerException("Property rx1024To1522Packets must not be null");
            }
            U64 u647 = rx1523ToMaxPackets = this.rx1523ToMaxPacketsSet ? this.rx1523ToMaxPackets : DEFAULT_RX_1523_TO_MAX_PACKETS;
            if (rx1523ToMaxPackets == null) {
                throw new NullPointerException("Property rx1523ToMaxPackets must not be null");
            }
            U64 u648 = tx1To64Packets = this.tx1To64PacketsSet ? this.tx1To64Packets : DEFAULT_TX_1_TO_64_PACKETS;
            if (tx1To64Packets == null) {
                throw new NullPointerException("Property tx1To64Packets must not be null");
            }
            U64 u649 = tx65To127Packets = this.tx65To127PacketsSet ? this.tx65To127Packets : DEFAULT_TX_65_TO_127_PACKETS;
            if (tx65To127Packets == null) {
                throw new NullPointerException("Property tx65To127Packets must not be null");
            }
            U64 u6410 = tx128To255Packets = this.tx128To255PacketsSet ? this.tx128To255Packets : DEFAULT_TX_128_TO_255_PACKETS;
            if (tx128To255Packets == null) {
                throw new NullPointerException("Property tx128To255Packets must not be null");
            }
            U64 u6411 = tx256To511Packets = this.tx256To511PacketsSet ? this.tx256To511Packets : DEFAULT_TX_256_TO_511_PACKETS;
            if (tx256To511Packets == null) {
                throw new NullPointerException("Property tx256To511Packets must not be null");
            }
            U64 u6412 = tx512To1023Packets = this.tx512To1023PacketsSet ? this.tx512To1023Packets : DEFAULT_TX_512_TO_1023_PACKETS;
            if (tx512To1023Packets == null) {
                throw new NullPointerException("Property tx512To1023Packets must not be null");
            }
            U64 u6413 = tx1024To1522Packets = this.tx1024To1522PacketsSet ? this.tx1024To1522Packets : DEFAULT_TX_1024_TO_1522_PACKETS;
            if (tx1024To1522Packets == null) {
                throw new NullPointerException("Property tx1024To1522Packets must not be null");
            }
            U64 u6414 = tx1523ToMaxPackets = this.tx1523ToMaxPacketsSet ? this.tx1523ToMaxPackets : DEFAULT_TX_1523_TO_MAX_PACKETS;
            if (tx1523ToMaxPackets == null) {
                throw new NullPointerException("Property tx1523ToMaxPackets must not be null");
            }
            U64 u6415 = txMulticastPackets = this.txMulticastPacketsSet ? this.txMulticastPackets : DEFAULT_TX_MULTICAST_PACKETS;
            if (txMulticastPackets == null) {
                throw new NullPointerException("Property txMulticastPackets must not be null");
            }
            U64 u6416 = rxBroadcastPackets = this.rxBroadcastPacketsSet ? this.rxBroadcastPackets : DEFAULT_RX_BROADCAST_PACKETS;
            if (rxBroadcastPackets == null) {
                throw new NullPointerException("Property rxBroadcastPackets must not be null");
            }
            U64 u6417 = txBroadcastPackets = this.txBroadcastPacketsSet ? this.txBroadcastPackets : DEFAULT_TX_BROADCAST_PACKETS;
            if (txBroadcastPackets == null) {
                throw new NullPointerException("Property txBroadcastPackets must not be null");
            }
            U64 u6418 = rxUndersizedErrors = this.rxUndersizedErrorsSet ? this.rxUndersizedErrors : DEFAULT_RX_UNDERSIZED_ERRORS;
            if (rxUndersizedErrors == null) {
                throw new NullPointerException("Property rxUndersizedErrors must not be null");
            }
            U64 u6419 = rxOversizeErrors = this.rxOversizeErrorsSet ? this.rxOversizeErrors : DEFAULT_RX_OVERSIZE_ERRORS;
            if (rxOversizeErrors == null) {
                throw new NullPointerException("Property rxOversizeErrors must not be null");
            }
            U64 u6420 = rxFragmentedErrors = this.rxFragmentedErrorsSet ? this.rxFragmentedErrors : DEFAULT_RX_FRAGMENTED_ERRORS;
            if (rxFragmentedErrors == null) {
                throw new NullPointerException("Property rxFragmentedErrors must not be null");
            }
            U64 u6421 = rxJabberErrors = this.rxJabberErrorsSet ? this.rxJabberErrors : DEFAULT_RX_JABBER_ERRORS;
            if (rxJabberErrors == null) {
                throw new NullPointerException("Property rxJabberErrors must not be null");
            }
            return new OFPortStatsPropExperimenterIntelVer15(rx1To64Packets, rx65To127Packets, rx128To255Packets, rx256To511Packets, rx512To1023Packets, rx1024To1522Packets, rx1523ToMaxPackets, tx1To64Packets, tx65To127Packets, tx128To255Packets, tx256To511Packets, tx512To1023Packets, tx1024To1522Packets, tx1523ToMaxPackets, txMulticastPackets, rxBroadcastPackets, txBroadcastPackets, rxUndersizedErrors, rxOversizeErrors, rxFragmentedErrors, rxJabberErrors);
        }
    }

    static class BuilderWithParent
    implements OFPortStatsPropExperimenterIntel.Builder {
        final OFPortStatsPropExperimenterIntelVer15 parentMessage;
        private boolean rx1To64PacketsSet;
        private U64 rx1To64Packets;
        private boolean rx65To127PacketsSet;
        private U64 rx65To127Packets;
        private boolean rx128To255PacketsSet;
        private U64 rx128To255Packets;
        private boolean rx256To511PacketsSet;
        private U64 rx256To511Packets;
        private boolean rx512To1023PacketsSet;
        private U64 rx512To1023Packets;
        private boolean rx1024To1522PacketsSet;
        private U64 rx1024To1522Packets;
        private boolean rx1523ToMaxPacketsSet;
        private U64 rx1523ToMaxPackets;
        private boolean tx1To64PacketsSet;
        private U64 tx1To64Packets;
        private boolean tx65To127PacketsSet;
        private U64 tx65To127Packets;
        private boolean tx128To255PacketsSet;
        private U64 tx128To255Packets;
        private boolean tx256To511PacketsSet;
        private U64 tx256To511Packets;
        private boolean tx512To1023PacketsSet;
        private U64 tx512To1023Packets;
        private boolean tx1024To1522PacketsSet;
        private U64 tx1024To1522Packets;
        private boolean tx1523ToMaxPacketsSet;
        private U64 tx1523ToMaxPackets;
        private boolean txMulticastPacketsSet;
        private U64 txMulticastPackets;
        private boolean rxBroadcastPacketsSet;
        private U64 rxBroadcastPackets;
        private boolean txBroadcastPacketsSet;
        private U64 txBroadcastPackets;
        private boolean rxUndersizedErrorsSet;
        private U64 rxUndersizedErrors;
        private boolean rxOversizeErrorsSet;
        private U64 rxOversizeErrors;
        private boolean rxFragmentedErrorsSet;
        private U64 rxFragmentedErrors;
        private boolean rxJabberErrorsSet;
        private U64 rxJabberErrors;

        BuilderWithParent(OFPortStatsPropExperimenterIntelVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 43521L;
        }

        @Override
        public long getExpType() {
            return 1L;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public U64 getRx1To64Packets() {
            return this.rx1To64Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx1To64Packets(U64 rx1To64Packets) {
            this.rx1To64Packets = rx1To64Packets;
            this.rx1To64PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx65To127Packets() {
            return this.rx65To127Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx65To127Packets(U64 rx65To127Packets) {
            this.rx65To127Packets = rx65To127Packets;
            this.rx65To127PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx128To255Packets() {
            return this.rx128To255Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx128To255Packets(U64 rx128To255Packets) {
            this.rx128To255Packets = rx128To255Packets;
            this.rx128To255PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx256To511Packets() {
            return this.rx256To511Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx256To511Packets(U64 rx256To511Packets) {
            this.rx256To511Packets = rx256To511Packets;
            this.rx256To511PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx512To1023Packets() {
            return this.rx512To1023Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx512To1023Packets(U64 rx512To1023Packets) {
            this.rx512To1023Packets = rx512To1023Packets;
            this.rx512To1023PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx1024To1522Packets() {
            return this.rx1024To1522Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx1024To1522Packets(U64 rx1024To1522Packets) {
            this.rx1024To1522Packets = rx1024To1522Packets;
            this.rx1024To1522PacketsSet = true;
            return this;
        }

        @Override
        public U64 getRx1523ToMaxPackets() {
            return this.rx1523ToMaxPackets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRx1523ToMaxPackets(U64 rx1523ToMaxPackets) {
            this.rx1523ToMaxPackets = rx1523ToMaxPackets;
            this.rx1523ToMaxPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx1To64Packets() {
            return this.tx1To64Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx1To64Packets(U64 tx1To64Packets) {
            this.tx1To64Packets = tx1To64Packets;
            this.tx1To64PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx65To127Packets() {
            return this.tx65To127Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx65To127Packets(U64 tx65To127Packets) {
            this.tx65To127Packets = tx65To127Packets;
            this.tx65To127PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx128To255Packets() {
            return this.tx128To255Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx128To255Packets(U64 tx128To255Packets) {
            this.tx128To255Packets = tx128To255Packets;
            this.tx128To255PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx256To511Packets() {
            return this.tx256To511Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx256To511Packets(U64 tx256To511Packets) {
            this.tx256To511Packets = tx256To511Packets;
            this.tx256To511PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx512To1023Packets() {
            return this.tx512To1023Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx512To1023Packets(U64 tx512To1023Packets) {
            this.tx512To1023Packets = tx512To1023Packets;
            this.tx512To1023PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx1024To1522Packets() {
            return this.tx1024To1522Packets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx1024To1522Packets(U64 tx1024To1522Packets) {
            this.tx1024To1522Packets = tx1024To1522Packets;
            this.tx1024To1522PacketsSet = true;
            return this;
        }

        @Override
        public U64 getTx1523ToMaxPackets() {
            return this.tx1523ToMaxPackets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTx1523ToMaxPackets(U64 tx1523ToMaxPackets) {
            this.tx1523ToMaxPackets = tx1523ToMaxPackets;
            this.tx1523ToMaxPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxMulticastPackets() {
            return this.txMulticastPackets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTxMulticastPackets(U64 txMulticastPackets) {
            this.txMulticastPackets = txMulticastPackets;
            this.txMulticastPacketsSet = true;
            return this;
        }

        @Override
        public U64 getRxBroadcastPackets() {
            return this.rxBroadcastPackets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRxBroadcastPackets(U64 rxBroadcastPackets) {
            this.rxBroadcastPackets = rxBroadcastPackets;
            this.rxBroadcastPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxBroadcastPackets() {
            return this.txBroadcastPackets;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setTxBroadcastPackets(U64 txBroadcastPackets) {
            this.txBroadcastPackets = txBroadcastPackets;
            this.txBroadcastPacketsSet = true;
            return this;
        }

        @Override
        public U64 getRxUndersizedErrors() {
            return this.rxUndersizedErrors;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRxUndersizedErrors(U64 rxUndersizedErrors) {
            this.rxUndersizedErrors = rxUndersizedErrors;
            this.rxUndersizedErrorsSet = true;
            return this;
        }

        @Override
        public U64 getRxOversizeErrors() {
            return this.rxOversizeErrors;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRxOversizeErrors(U64 rxOversizeErrors) {
            this.rxOversizeErrors = rxOversizeErrors;
            this.rxOversizeErrorsSet = true;
            return this;
        }

        @Override
        public U64 getRxFragmentedErrors() {
            return this.rxFragmentedErrors;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRxFragmentedErrors(U64 rxFragmentedErrors) {
            this.rxFragmentedErrors = rxFragmentedErrors;
            this.rxFragmentedErrorsSet = true;
            return this;
        }

        @Override
        public U64 getRxJabberErrors() {
            return this.rxJabberErrors;
        }

        @Override
        public OFPortStatsPropExperimenterIntel.Builder setRxJabberErrors(U64 rxJabberErrors) {
            this.rxJabberErrors = rxJabberErrors;
            this.rxJabberErrorsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortStatsPropExperimenterIntel build() {
            U64 rxJabberErrors;
            U64 rxFragmentedErrors;
            U64 rxOversizeErrors;
            U64 rxUndersizedErrors;
            U64 txBroadcastPackets;
            U64 rxBroadcastPackets;
            U64 txMulticastPackets;
            U64 tx1523ToMaxPackets;
            U64 tx1024To1522Packets;
            U64 tx512To1023Packets;
            U64 tx256To511Packets;
            U64 tx128To255Packets;
            U64 tx65To127Packets;
            U64 tx1To64Packets;
            U64 rx1523ToMaxPackets;
            U64 rx1024To1522Packets;
            U64 rx512To1023Packets;
            U64 rx256To511Packets;
            U64 rx128To255Packets;
            U64 rx65To127Packets;
            U64 rx1To64Packets;
            U64 u64 = rx1To64Packets = this.rx1To64PacketsSet ? this.rx1To64Packets : this.parentMessage.rx1To64Packets;
            if (rx1To64Packets == null) {
                throw new NullPointerException("Property rx1To64Packets must not be null");
            }
            U64 u642 = rx65To127Packets = this.rx65To127PacketsSet ? this.rx65To127Packets : this.parentMessage.rx65To127Packets;
            if (rx65To127Packets == null) {
                throw new NullPointerException("Property rx65To127Packets must not be null");
            }
            U64 u643 = rx128To255Packets = this.rx128To255PacketsSet ? this.rx128To255Packets : this.parentMessage.rx128To255Packets;
            if (rx128To255Packets == null) {
                throw new NullPointerException("Property rx128To255Packets must not be null");
            }
            U64 u644 = rx256To511Packets = this.rx256To511PacketsSet ? this.rx256To511Packets : this.parentMessage.rx256To511Packets;
            if (rx256To511Packets == null) {
                throw new NullPointerException("Property rx256To511Packets must not be null");
            }
            U64 u645 = rx512To1023Packets = this.rx512To1023PacketsSet ? this.rx512To1023Packets : this.parentMessage.rx512To1023Packets;
            if (rx512To1023Packets == null) {
                throw new NullPointerException("Property rx512To1023Packets must not be null");
            }
            U64 u646 = rx1024To1522Packets = this.rx1024To1522PacketsSet ? this.rx1024To1522Packets : this.parentMessage.rx1024To1522Packets;
            if (rx1024To1522Packets == null) {
                throw new NullPointerException("Property rx1024To1522Packets must not be null");
            }
            U64 u647 = rx1523ToMaxPackets = this.rx1523ToMaxPacketsSet ? this.rx1523ToMaxPackets : this.parentMessage.rx1523ToMaxPackets;
            if (rx1523ToMaxPackets == null) {
                throw new NullPointerException("Property rx1523ToMaxPackets must not be null");
            }
            U64 u648 = tx1To64Packets = this.tx1To64PacketsSet ? this.tx1To64Packets : this.parentMessage.tx1To64Packets;
            if (tx1To64Packets == null) {
                throw new NullPointerException("Property tx1To64Packets must not be null");
            }
            U64 u649 = tx65To127Packets = this.tx65To127PacketsSet ? this.tx65To127Packets : this.parentMessage.tx65To127Packets;
            if (tx65To127Packets == null) {
                throw new NullPointerException("Property tx65To127Packets must not be null");
            }
            U64 u6410 = tx128To255Packets = this.tx128To255PacketsSet ? this.tx128To255Packets : this.parentMessage.tx128To255Packets;
            if (tx128To255Packets == null) {
                throw new NullPointerException("Property tx128To255Packets must not be null");
            }
            U64 u6411 = tx256To511Packets = this.tx256To511PacketsSet ? this.tx256To511Packets : this.parentMessage.tx256To511Packets;
            if (tx256To511Packets == null) {
                throw new NullPointerException("Property tx256To511Packets must not be null");
            }
            U64 u6412 = tx512To1023Packets = this.tx512To1023PacketsSet ? this.tx512To1023Packets : this.parentMessage.tx512To1023Packets;
            if (tx512To1023Packets == null) {
                throw new NullPointerException("Property tx512To1023Packets must not be null");
            }
            U64 u6413 = tx1024To1522Packets = this.tx1024To1522PacketsSet ? this.tx1024To1522Packets : this.parentMessage.tx1024To1522Packets;
            if (tx1024To1522Packets == null) {
                throw new NullPointerException("Property tx1024To1522Packets must not be null");
            }
            U64 u6414 = tx1523ToMaxPackets = this.tx1523ToMaxPacketsSet ? this.tx1523ToMaxPackets : this.parentMessage.tx1523ToMaxPackets;
            if (tx1523ToMaxPackets == null) {
                throw new NullPointerException("Property tx1523ToMaxPackets must not be null");
            }
            U64 u6415 = txMulticastPackets = this.txMulticastPacketsSet ? this.txMulticastPackets : this.parentMessage.txMulticastPackets;
            if (txMulticastPackets == null) {
                throw new NullPointerException("Property txMulticastPackets must not be null");
            }
            U64 u6416 = rxBroadcastPackets = this.rxBroadcastPacketsSet ? this.rxBroadcastPackets : this.parentMessage.rxBroadcastPackets;
            if (rxBroadcastPackets == null) {
                throw new NullPointerException("Property rxBroadcastPackets must not be null");
            }
            U64 u6417 = txBroadcastPackets = this.txBroadcastPacketsSet ? this.txBroadcastPackets : this.parentMessage.txBroadcastPackets;
            if (txBroadcastPackets == null) {
                throw new NullPointerException("Property txBroadcastPackets must not be null");
            }
            U64 u6418 = rxUndersizedErrors = this.rxUndersizedErrorsSet ? this.rxUndersizedErrors : this.parentMessage.rxUndersizedErrors;
            if (rxUndersizedErrors == null) {
                throw new NullPointerException("Property rxUndersizedErrors must not be null");
            }
            U64 u6419 = rxOversizeErrors = this.rxOversizeErrorsSet ? this.rxOversizeErrors : this.parentMessage.rxOversizeErrors;
            if (rxOversizeErrors == null) {
                throw new NullPointerException("Property rxOversizeErrors must not be null");
            }
            U64 u6420 = rxFragmentedErrors = this.rxFragmentedErrorsSet ? this.rxFragmentedErrors : this.parentMessage.rxFragmentedErrors;
            if (rxFragmentedErrors == null) {
                throw new NullPointerException("Property rxFragmentedErrors must not be null");
            }
            U64 u6421 = rxJabberErrors = this.rxJabberErrorsSet ? this.rxJabberErrors : this.parentMessage.rxJabberErrors;
            if (rxJabberErrors == null) {
                throw new NullPointerException("Property rxJabberErrors must not be null");
            }
            return new OFPortStatsPropExperimenterIntelVer15(rx1To64Packets, rx65To127Packets, rx128To255Packets, rx256To511Packets, rx512To1023Packets, rx1024To1522Packets, rx1523ToMaxPackets, tx1To64Packets, tx65To127Packets, tx128To255Packets, tx256To511Packets, tx512To1023Packets, tx1024To1522Packets, tx1523ToMaxPackets, txMulticastPackets, rxBroadcastPackets, txBroadcastPackets, rxUndersizedErrors, rxOversizeErrors, rxFragmentedErrors, rxJabberErrors);
        }
    }
}

