/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOvsTcpFlags;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmOvsTcpFlagsVer15
implements OFOxmOvsTcpFlags {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmOvsTcpFlagsVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 10;
    private static final U16 DEFAULT_VALUE = U16.ZERO;
    private final U16 value;
    static final OFOxmOvsTcpFlagsVer15 DEFAULT = new OFOxmOvsTcpFlagsVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmOvsTcpFlagsVer15Funnel FUNNEL = new OFOxmOvsTcpFlagsVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmOvsTcpFlagsVer15(U16 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmOvsTcpFlagsVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 4294923270L;
    }

    @Override
    public long getExperimenterId() {
        return 1330529792L;
    }

    @Override
    public U16 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U16> getMatchField() {
        return MatchField.OVS_TCP_FLAGS;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U16> getCanonical() {
        return this;
    }

    @Override
    public U16 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmOvsTcpFlags.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmOvsTcpFlagsVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmOvsTcpFlagsVer15 other = (OFOxmOvsTcpFlagsVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmOvsTcpFlagsVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmOvsTcpFlagsVer15 message) {
            bb.writeInt(-44026);
            bb.writeInt(1330529792);
            bb.writeShort((int)message.value.getRaw());
        }
    }

    static class OFOxmOvsTcpFlagsVer15Funnel
    implements Funnel<OFOxmOvsTcpFlagsVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmOvsTcpFlagsVer15Funnel() {
        }

        public void funnel(OFOxmOvsTcpFlagsVer15 message, PrimitiveSink sink) {
            sink.putInt(-44026);
            sink.putInt(1330529792);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmOvsTcpFlags> {
        Reader() {
        }

        @Override
        public OFOxmOvsTcpFlags readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -44026) {
                throw new OFParseError("Wrong typeLen: Expected=0xffff5406L(0xffff5406L), got=" + typeLen);
            }
            int experimenterId = bb.readInt();
            if (experimenterId != 1330529792) {
                throw new OFParseError("Wrong experimenterId: Expected=0x4f4e4600L(0x4f4e4600L), got=" + experimenterId);
            }
            U16 value = U16.of(bb.readShort());
            OFOxmOvsTcpFlagsVer15 oxmOvsTcpFlagsVer15 = new OFOxmOvsTcpFlagsVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmOvsTcpFlagsVer15);
            }
            return oxmOvsTcpFlagsVer15;
        }
    }

    static class Builder
    implements OFOxmOvsTcpFlags.Builder {
        private boolean valueSet;
        private U16 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 4294923270L;
        }

        @Override
        public long getExperimenterId() {
            return 1330529792L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmOvsTcpFlags.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.OVS_TCP_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmOvsTcpFlags build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOvsTcpFlagsVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmOvsTcpFlags.Builder {
        final OFOxmOvsTcpFlagsVer15 parentMessage;
        private boolean valueSet;
        private U16 value;

        BuilderWithParent(OFOxmOvsTcpFlagsVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 4294923270L;
        }

        @Override
        public long getExperimenterId() {
            return 1330529792L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmOvsTcpFlags.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.OVS_TCP_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmOvsTcpFlags build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOvsTcpFlagsVer15(value);
        }
    }
}

