/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpProtoMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmIpProtoVer15;
import org.projectfloodlight.openflow.types.IpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpProtoMaskedVer15
implements OFOxmIpProtoMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpProtoMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final IpProtocol DEFAULT_VALUE = IpProtocol.NONE;
    private static final IpProtocol DEFAULT_VALUE_MASK = IpProtocol.NONE;
    private final IpProtocol value;
    private final IpProtocol mask;
    static final OFOxmIpProtoMaskedVer15 DEFAULT = new OFOxmIpProtoMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIpProtoMaskedVer15Funnel FUNNEL = new OFOxmIpProtoMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpProtoMaskedVer15(IpProtocol value, IpProtocol mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpProtoMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmIpProtoMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147489026L;
    }

    @Override
    public IpProtocol getValue() {
        return this.value;
    }

    @Override
    public IpProtocol getMask() {
        return this.mask;
    }

    @Override
    public MatchField<IpProtocol> getMatchField() {
        return MatchField.IP_PROTO;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<IpProtocol> getCanonical() {
        if (IpProtocol.NO_MASK.equals(this.mask)) {
            return new OFOxmIpProtoVer15(this.value);
        }
        if (IpProtocol.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmIpProtoMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpProtoMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpProtoMaskedVer15 other = (OFOxmIpProtoMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpProtoMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIpProtoMaskedVer15 message) {
            bb.writeInt(-2147478270);
            message.value.writeByte(bb);
            message.mask.writeByte(bb);
        }
    }

    static class OFOxmIpProtoMaskedVer15Funnel
    implements Funnel<OFOxmIpProtoMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmIpProtoMaskedVer15Funnel() {
        }

        public void funnel(OFOxmIpProtoMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147478270);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpProtoMasked> {
        Reader() {
        }

        @Override
        public OFOxmIpProtoMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147478270) {
                throw new OFParseError("Wrong typeLen: Expected=0x80001502L(0x80001502L), got=" + typeLen);
            }
            IpProtocol value = IpProtocol.readByte(bb);
            IpProtocol mask = IpProtocol.readByte(bb);
            OFOxmIpProtoMaskedVer15 oxmIpProtoMaskedVer15 = new OFOxmIpProtoMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpProtoMaskedVer15);
            }
            return oxmIpProtoMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmIpProtoMasked.Builder {
        private boolean valueSet;
        private IpProtocol value;
        private boolean maskSet;
        private IpProtocol mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147489026L;
        }

        @Override
        public IpProtocol getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpProtoMasked.Builder setValue(IpProtocol value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IpProtocol getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpProtoMasked.Builder setMask(IpProtocol mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IpProtocol> getMatchField() {
            return MatchField.IP_PROTO;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IpProtocol> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmIpProtoMasked build() {
            IpProtocol mask;
            IpProtocol value;
            IpProtocol ipProtocol = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IpProtocol ipProtocol2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpProtoMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpProtoMasked.Builder {
        final OFOxmIpProtoMaskedVer15 parentMessage;
        private boolean valueSet;
        private IpProtocol value;
        private boolean maskSet;
        private IpProtocol mask;

        BuilderWithParent(OFOxmIpProtoMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147489026L;
        }

        @Override
        public IpProtocol getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpProtoMasked.Builder setValue(IpProtocol value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IpProtocol getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpProtoMasked.Builder setMask(IpProtocol mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IpProtocol> getMatchField() {
            return MatchField.IP_PROTO;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IpProtocol> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmIpProtoMasked build() {
            IpProtocol mask;
            IpProtocol value;
            IpProtocol ipProtocol = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IpProtocol ipProtocol2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpProtoMaskedVer15(value, mask);
        }
    }
}

