/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionIdWriteMetadata;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionIdWriteMetadataVer15
implements OFInstructionIdWriteMetadata {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionIdWriteMetadataVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 4;
    static final OFInstructionIdWriteMetadataVer15 DEFAULT = new OFInstructionIdWriteMetadataVer15();
    static final OFInstructionIdWriteMetadataVer15 INSTANCE = new OFInstructionIdWriteMetadataVer15();
    static final Reader READER = new Reader();
    static final OFInstructionIdWriteMetadataVer15Funnel FUNNEL = new OFInstructionIdWriteMetadataVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFInstructionIdWriteMetadataVer15() {
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.WRITE_METADATA;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFInstructionIdWriteMetadata.Builder createBuilder() {
        throw new UnsupportedOperationException("OFInstructionIdWriteMetadataVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionIdWriteMetadataVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionIdWriteMetadataVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionIdWriteMetadataVer15 message) {
            bb.writeShort(2);
            bb.writeShort(4);
        }
    }

    static class OFInstructionIdWriteMetadataVer15Funnel
    implements Funnel<OFInstructionIdWriteMetadataVer15> {
        private static final long serialVersionUID = 1L;

        OFInstructionIdWriteMetadataVer15Funnel() {
        }

        public void funnel(OFInstructionIdWriteMetadataVer15 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionIdWriteMetadata> {
        Reader() {
        }

        @Override
        public OFInstructionIdWriteMetadata readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.WRITE_METADATA(2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

