/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBundleFeatureFlags;
import org.projectfloodlight.openflow.protocol.OFBundleFeaturesProp;
import org.projectfloodlight.openflow.protocol.OFBundleFeaturesStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleFeatureFlagsSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleFeaturesPropVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsReplyFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBundleFeaturesStatsReplyVer15
implements OFBundleFeaturesStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBundleFeaturesStatsReplyVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 26;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final Set<OFBundleFeatureFlags> DEFAULT_CAPABILITIES = ImmutableSet.of();
    private static final List<OFBundleFeaturesProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final Set<OFBundleFeatureFlags> capabilities;
    private final List<OFBundleFeaturesProp> properties;
    static final OFBundleFeaturesStatsReplyVer15 DEFAULT = new OFBundleFeaturesStatsReplyVer15(0L, DEFAULT_FLAGS, DEFAULT_CAPABILITIES, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFBundleFeaturesStatsReplyVer15Funnel FUNNEL = new OFBundleFeaturesStatsReplyVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBundleFeaturesStatsReplyVer15(long xid, Set<OFStatsReplyFlags> flags, Set<OFBundleFeatureFlags> capabilities, List<OFBundleFeaturesProp> properties) {
        if (flags == null) {
            throw new NullPointerException("OFBundleFeaturesStatsReplyVer15: property flags cannot be null");
        }
        if (capabilities == null) {
            throw new NullPointerException("OFBundleFeaturesStatsReplyVer15: property capabilities cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFBundleFeaturesStatsReplyVer15: property properties cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.capabilities = capabilities;
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.BUNDLE_FEATURES;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public Set<OFBundleFeatureFlags> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public List<OFBundleFeaturesProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFBundleFeaturesStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBundleFeaturesStatsReplyVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("capabilities=").append(this.capabilities);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleFeaturesStatsReplyVer15 other = (OFBundleFeaturesStatsReplyVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleFeaturesStatsReplyVer15 other = (OFBundleFeaturesStatsReplyVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBundleFeaturesStatsReplyVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBundleFeaturesStatsReplyVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(19);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(19);
            OFStatsReplyFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeZero(4);
            OFBundleFeatureFlagsSerializerVer15.writeTo(bb, message.capabilities);
            bb.writeZero(6);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBundleFeaturesStatsReplyVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBundleFeaturesStatsReplyVer15Funnel
    implements Funnel<OFBundleFeaturesStatsReplyVer15> {
        private static final long serialVersionUID = 1L;

        OFBundleFeaturesStatsReplyVer15Funnel() {
        }

        public void funnel(OFBundleFeaturesStatsReplyVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)19);
            sink.putLong(message.xid);
            sink.putShort((short)19);
            OFStatsReplyFlagsSerializerVer15.putTo(message.flags, sink);
            OFBundleFeatureFlagsSerializerVer15.putTo(message.capabilities, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBundleFeaturesStatsReply> {
        Reader() {
        }

        @Override
        public OFBundleFeaturesStatsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 26) {
                throw new OFParseError("Wrong length: Expected to be >= 26, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 19) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.BUNDLE_FEATURES(19), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            Set<OFBundleFeatureFlags> capabilities = OFBundleFeatureFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(6);
            List<OFBundleFeaturesProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBundleFeaturesPropVer15.READER);
            OFBundleFeaturesStatsReplyVer15 bundleFeaturesStatsReplyVer15 = new OFBundleFeaturesStatsReplyVer15(xid, flags, capabilities, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bundleFeaturesStatsReplyVer15);
            }
            return bundleFeaturesStatsReplyVer15;
        }
    }

    static class Builder
    implements OFBundleFeaturesStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean capabilitiesSet;
        private Set<OFBundleFeatureFlags> capabilities;
        private boolean propertiesSet;
        private List<OFBundleFeaturesProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleFeaturesStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.BUNDLE_FEATURES;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleFeaturesStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFeatureFlags> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFBundleFeaturesStatsReply.Builder setCapabilities(Set<OFBundleFeatureFlags> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public List<OFBundleFeaturesProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBundleFeaturesStatsReply.Builder setProperties(List<OFBundleFeaturesProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFBundleFeaturesStatsReply build() {
            List<OFBundleFeaturesProp> properties;
            Set<OFBundleFeatureFlags> capabilities;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            Set<OFBundleFeatureFlags> set2 = capabilities = this.capabilitiesSet ? this.capabilities : DEFAULT_CAPABILITIES;
            if (capabilities == null) {
                throw new NullPointerException("Property capabilities must not be null");
            }
            List<OFBundleFeaturesProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBundleFeaturesStatsReplyVer15(xid, flags, capabilities, properties);
        }
    }

    static class BuilderWithParent
    implements OFBundleFeaturesStatsReply.Builder {
        final OFBundleFeaturesStatsReplyVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean capabilitiesSet;
        private Set<OFBundleFeatureFlags> capabilities;
        private boolean propertiesSet;
        private List<OFBundleFeaturesProp> properties;

        BuilderWithParent(OFBundleFeaturesStatsReplyVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleFeaturesStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.BUNDLE_FEATURES;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleFeaturesStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFeatureFlags> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFBundleFeaturesStatsReply.Builder setCapabilities(Set<OFBundleFeatureFlags> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public List<OFBundleFeaturesProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBundleFeaturesStatsReply.Builder setProperties(List<OFBundleFeaturesProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFBundleFeaturesStatsReply build() {
            List properties;
            Set capabilities;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            Set set2 = capabilities = this.capabilitiesSet ? this.capabilities : this.parentMessage.capabilities;
            if (capabilities == null) {
                throw new NullPointerException("Property capabilities must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBundleFeaturesStatsReplyVer15(xid, flags, capabilities, properties);
        }
    }
}

