/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnTunnelType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvTunnelCapability;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTunnelTypeSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvTunnelCapabilityVer15
implements OFBsnTlvTunnelCapability {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvTunnelCapabilityVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final Set<OFBsnTunnelType> DEFAULT_VALUE = ImmutableSet.of();
    private final Set<OFBsnTunnelType> value;
    static final OFBsnTlvTunnelCapabilityVer15 DEFAULT = new OFBsnTlvTunnelCapabilityVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvTunnelCapabilityVer15Funnel FUNNEL = new OFBsnTlvTunnelCapabilityVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvTunnelCapabilityVer15(Set<OFBsnTunnelType> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvTunnelCapabilityVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 142;
    }

    @Override
    public Set<OFBsnTunnelType> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvTunnelCapability.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvTunnelCapabilityVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvTunnelCapabilityVer15 other = (OFBsnTlvTunnelCapabilityVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvTunnelCapabilityVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvTunnelCapabilityVer15 message) {
            bb.writeShort(142);
            bb.writeShort(12);
            OFBsnTunnelTypeSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvTunnelCapabilityVer15Funnel
    implements Funnel<OFBsnTlvTunnelCapabilityVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvTunnelCapabilityVer15Funnel() {
        }

        public void funnel(OFBsnTlvTunnelCapabilityVer15 message, PrimitiveSink sink) {
            sink.putShort((short)142);
            sink.putShort((short)12);
            OFBsnTunnelTypeSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvTunnelCapability> {
        Reader() {
        }

        @Override
        public OFBsnTlvTunnelCapability readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 142) {
                throw new OFParseError("Wrong type: Expected=0x8e(0x8e), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnTunnelType> value = OFBsnTunnelTypeSerializerVer15.readFrom(bb);
            OFBsnTlvTunnelCapabilityVer15 bsnTlvTunnelCapabilityVer15 = new OFBsnTlvTunnelCapabilityVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvTunnelCapabilityVer15);
            }
            return bsnTlvTunnelCapabilityVer15;
        }
    }

    static class Builder
    implements OFBsnTlvTunnelCapability.Builder {
        private boolean valueSet;
        private Set<OFBsnTunnelType> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 142;
        }

        @Override
        public Set<OFBsnTunnelType> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTunnelCapability.Builder setValue(Set<OFBsnTunnelType> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvTunnelCapability build() {
            Set<OFBsnTunnelType> value;
            Set<OFBsnTunnelType> set = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvTunnelCapabilityVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvTunnelCapability.Builder {
        final OFBsnTlvTunnelCapabilityVer15 parentMessage;
        private boolean valueSet;
        private Set<OFBsnTunnelType> value;

        BuilderWithParent(OFBsnTlvTunnelCapabilityVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 142;
        }

        @Override
        public Set<OFBsnTunnelType> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTunnelCapability.Builder setValue(Set<OFBsnTunnelType> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvTunnelCapability build() {
            Set value;
            Set set = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvTunnelCapabilityVer15(value);
        }
    }
}

