/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvEgressSamplingRate;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvEgressSamplingRateVer15
implements OFBsnTlvEgressSamplingRate {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvEgressSamplingRateVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvEgressSamplingRateVer15 DEFAULT = new OFBsnTlvEgressSamplingRateVer15(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvEgressSamplingRateVer15Funnel FUNNEL = new OFBsnTlvEgressSamplingRateVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvEgressSamplingRateVer15(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 195;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvEgressSamplingRate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvEgressSamplingRateVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvEgressSamplingRateVer15 other = (OFBsnTlvEgressSamplingRateVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvEgressSamplingRateVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvEgressSamplingRateVer15 message) {
            bb.writeShort(195);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvEgressSamplingRateVer15Funnel
    implements Funnel<OFBsnTlvEgressSamplingRateVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvEgressSamplingRateVer15Funnel() {
        }

        public void funnel(OFBsnTlvEgressSamplingRateVer15 message, PrimitiveSink sink) {
            sink.putShort((short)195);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvEgressSamplingRate> {
        Reader() {
        }

        @Override
        public OFBsnTlvEgressSamplingRate readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 195) {
                throw new OFParseError("Wrong type: Expected=0xc3(0xc3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvEgressSamplingRateVer15 bsnTlvEgressSamplingRateVer15 = new OFBsnTlvEgressSamplingRateVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvEgressSamplingRateVer15);
            }
            return bsnTlvEgressSamplingRateVer15;
        }
    }

    static class Builder
    implements OFBsnTlvEgressSamplingRate.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 195;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEgressSamplingRate.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvEgressSamplingRate build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvEgressSamplingRateVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvEgressSamplingRate.Builder {
        final OFBsnTlvEgressSamplingRateVer15 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvEgressSamplingRateVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 195;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEgressSamplingRate.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvEgressSamplingRate build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvEgressSamplingRateVer15(value);
        }
    }
}

