/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnDecap;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvDecap;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnDecapSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvDecapVer15
implements OFBsnTlvDecap {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvDecapVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnDecap value;
    static final Reader READER = new Reader();
    static final OFBsnTlvDecapVer15Funnel FUNNEL = new OFBsnTlvDecapVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvDecapVer15(OFBsnDecap value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvDecapVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 85;
    }

    @Override
    public OFBsnDecap getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvDecap.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvDecapVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvDecapVer15 other = (OFBsnTlvDecapVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvDecapVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvDecapVer15 message) {
            bb.writeShort(85);
            bb.writeShort(6);
            OFBsnDecapSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvDecapVer15Funnel
    implements Funnel<OFBsnTlvDecapVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvDecapVer15Funnel() {
        }

        public void funnel(OFBsnTlvDecapVer15 message, PrimitiveSink sink) {
            sink.putShort((short)85);
            sink.putShort((short)6);
            OFBsnDecapSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvDecap> {
        Reader() {
        }

        @Override
        public OFBsnTlvDecap readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 85) {
                throw new OFParseError("Wrong type: Expected=0x55(0x55), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnDecap value = OFBsnDecapSerializerVer15.readFrom(bb);
            OFBsnTlvDecapVer15 bsnTlvDecapVer15 = new OFBsnTlvDecapVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvDecapVer15);
            }
            return bsnTlvDecapVer15;
        }
    }

    static class Builder
    implements OFBsnTlvDecap.Builder {
        private boolean valueSet;
        private OFBsnDecap value;

        Builder() {
        }

        @Override
        public int getType() {
            return 85;
        }

        @Override
        public OFBsnDecap getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvDecap.Builder setValue(OFBsnDecap value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvDecap build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvDecapVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvDecap.Builder {
        final OFBsnTlvDecapVer15 parentMessage;
        private boolean valueSet;
        private OFBsnDecap value;

        BuilderWithParent(OFBsnTlvDecapVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 85;
        }

        @Override
        public OFBsnDecap getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvDecap.Builder setValue(OFBsnDecap value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvDecap build() {
            OFBsnDecap value;
            OFBsnDecap oFBsnDecap = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvDecapVer15(value);
        }
    }
}

