/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnActionState;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvActionState;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnActionStateSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvActionStateVer15
implements OFBsnTlvActionState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvActionStateVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnActionState value;
    static final Reader READER = new Reader();
    static final OFBsnTlvActionStateVer15Funnel FUNNEL = new OFBsnTlvActionStateVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvActionStateVer15(OFBsnActionState value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvActionStateVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 226;
    }

    @Override
    public OFBsnActionState getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvActionState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvActionStateVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvActionStateVer15 other = (OFBsnTlvActionStateVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvActionStateVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvActionStateVer15 message) {
            bb.writeShort(226);
            bb.writeShort(6);
            OFBsnActionStateSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvActionStateVer15Funnel
    implements Funnel<OFBsnTlvActionStateVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvActionStateVer15Funnel() {
        }

        public void funnel(OFBsnTlvActionStateVer15 message, PrimitiveSink sink) {
            sink.putShort((short)226);
            sink.putShort((short)6);
            OFBsnActionStateSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvActionState> {
        Reader() {
        }

        @Override
        public OFBsnTlvActionState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 226) {
                throw new OFParseError("Wrong type: Expected=0xe2(0xe2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnActionState value = OFBsnActionStateSerializerVer15.readFrom(bb);
            OFBsnTlvActionStateVer15 bsnTlvActionStateVer15 = new OFBsnTlvActionStateVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvActionStateVer15);
            }
            return bsnTlvActionStateVer15;
        }
    }

    static class Builder
    implements OFBsnTlvActionState.Builder {
        private boolean valueSet;
        private OFBsnActionState value;

        Builder() {
        }

        @Override
        public int getType() {
            return 226;
        }

        @Override
        public OFBsnActionState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActionState.Builder setValue(OFBsnActionState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvActionState build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvActionStateVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvActionState.Builder {
        final OFBsnTlvActionStateVer15 parentMessage;
        private boolean valueSet;
        private OFBsnActionState value;

        BuilderWithParent(OFBsnTlvActionStateVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 226;
        }

        @Override
        public OFBsnActionState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActionState.Builder setValue(OFBsnActionState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvActionState build() {
            OFBsnActionState value;
            OFBsnActionState oFBsnActionState = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvActionStateVer15(value);
        }
    }
}

