/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSwitchPipelineStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnSwitchPipelineStatsEntryVer15
implements OFBsnSwitchPipelineStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSwitchPipelineStatsEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 256;
    private static final String DEFAULT_PIPELINE = "";
    private final String pipeline;
    static final OFBsnSwitchPipelineStatsEntryVer15 DEFAULT = new OFBsnSwitchPipelineStatsEntryVer15("");
    static final Reader READER = new Reader();
    static final OFBsnSwitchPipelineStatsEntryVer15Funnel FUNNEL = new OFBsnSwitchPipelineStatsEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnSwitchPipelineStatsEntryVer15(String pipeline) {
        if (pipeline == null) {
            throw new NullPointerException("OFBsnSwitchPipelineStatsEntryVer15: property pipeline cannot be null");
        }
        this.pipeline = pipeline;
    }

    @Override
    public String getPipeline() {
        return this.pipeline;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnSwitchPipelineStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSwitchPipelineStatsEntryVer15(");
        b.append("pipeline=").append(this.pipeline);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSwitchPipelineStatsEntryVer15 other = (OFBsnSwitchPipelineStatsEntryVer15)obj;
        return !(this.pipeline == null ? other.pipeline != null : !this.pipeline.equals(other.pipeline));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pipeline == null ? 0 : this.pipeline.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnSwitchPipelineStatsEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnSwitchPipelineStatsEntryVer15 message) {
            ChannelUtils.writeFixedLengthString(bb, message.pipeline, 256);
        }
    }

    static class OFBsnSwitchPipelineStatsEntryVer15Funnel
    implements Funnel<OFBsnSwitchPipelineStatsEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnSwitchPipelineStatsEntryVer15Funnel() {
        }

        public void funnel(OFBsnSwitchPipelineStatsEntryVer15 message, PrimitiveSink sink) {
            sink.putUnencodedChars((CharSequence)message.pipeline);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnSwitchPipelineStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnSwitchPipelineStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            String pipeline = ChannelUtils.readFixedLengthString(bb, 256);
            OFBsnSwitchPipelineStatsEntryVer15 bsnSwitchPipelineStatsEntryVer15 = new OFBsnSwitchPipelineStatsEntryVer15(pipeline);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnSwitchPipelineStatsEntryVer15);
            }
            return bsnSwitchPipelineStatsEntryVer15;
        }
    }

    static class Builder
    implements OFBsnSwitchPipelineStatsEntry.Builder {
        private boolean pipelineSet;
        private String pipeline;

        Builder() {
        }

        @Override
        public String getPipeline() {
            return this.pipeline;
        }

        @Override
        public OFBsnSwitchPipelineStatsEntry.Builder setPipeline(String pipeline) {
            this.pipeline = pipeline;
            this.pipelineSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnSwitchPipelineStatsEntry build() {
            String pipeline;
            String string = pipeline = this.pipelineSet ? this.pipeline : OFBsnSwitchPipelineStatsEntryVer15.DEFAULT_PIPELINE;
            if (pipeline == null) {
                throw new NullPointerException("Property pipeline must not be null");
            }
            return new OFBsnSwitchPipelineStatsEntryVer15(pipeline);
        }
    }

    static class BuilderWithParent
    implements OFBsnSwitchPipelineStatsEntry.Builder {
        final OFBsnSwitchPipelineStatsEntryVer15 parentMessage;
        private boolean pipelineSet;
        private String pipeline;

        BuilderWithParent(OFBsnSwitchPipelineStatsEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public String getPipeline() {
            return this.pipeline;
        }

        @Override
        public OFBsnSwitchPipelineStatsEntry.Builder setPipeline(String pipeline) {
            this.pipeline = pipeline;
            this.pipelineSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnSwitchPipelineStatsEntry build() {
            String pipeline;
            String string = pipeline = this.pipelineSet ? this.pipeline : this.parentMessage.pipeline;
            if (pipeline == null) {
                throw new NullPointerException("Property pipeline must not be null");
            }
            return new OFBsnSwitchPipelineStatsEntryVer15(pipeline);
        }
    }
}

