/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigProp;
import org.projectfloodlight.openflow.protocol.OFAsyncSet;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFAsyncConfigPropVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncSetVer15
implements OFAsyncSet {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncSetVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final List<OFAsyncConfigProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final List<OFAsyncConfigProp> properties;
    static final OFAsyncSetVer15 DEFAULT = new OFAsyncSetVer15(0L, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFAsyncSetVer15Funnel FUNNEL = new OFAsyncSetVer15Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncSetVer15(long xid, List<OFAsyncConfigProp> properties) {
        if (properties == null) {
            throw new NullPointerException("OFAsyncSetVer15: property properties cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.SET_ASYNC;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getPacketInMaskEqualMaster() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetInMaskEqualMaster not supported in version 1.5");
    }

    @Override
    public long getPacketInMaskSlave() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetInMaskSlave not supported in version 1.5");
    }

    @Override
    public long getPortStatusMaskEqualMaster() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property portStatusMaskEqualMaster not supported in version 1.5");
    }

    @Override
    public long getPortStatusMaskSlave() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property portStatusMaskSlave not supported in version 1.5");
    }

    @Override
    public long getFlowRemovedMaskEqualMaster() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property flowRemovedMaskEqualMaster not supported in version 1.5");
    }

    @Override
    public long getFlowRemovedMaskSlave() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property flowRemovedMaskSlave not supported in version 1.5");
    }

    @Override
    public List<OFAsyncConfigProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFAsyncSet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncSetVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncSetVer15 other = (OFAsyncSetVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncSetVer15 other = (OFAsyncSetVer15)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncSetVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncSetVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(28);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFAsyncSetVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFAsyncSetVer15Funnel
    implements Funnel<OFAsyncSetVer15> {
        private static final long serialVersionUID = 1L;

        OFAsyncSetVer15Funnel() {
        }

        public void funnel(OFAsyncSetVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)28);
            sink.putLong(message.xid);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncSet> {
        Reader() {
        }

        @Override
        public OFAsyncSet readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 28) {
                throw new OFParseError("Wrong type: Expected=OFType.SET_ASYNC(28), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            List<OFAsyncConfigProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFAsyncConfigPropVer15.READER);
            OFAsyncSetVer15 asyncSetVer15 = new OFAsyncSetVer15(xid, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncSetVer15);
            }
            return asyncSetVer15;
        }
    }

    static class Builder
    implements OFAsyncSet.Builder {
        private boolean xidSet;
        private long xid;
        private boolean propertiesSet;
        private List<OFAsyncConfigProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.SET_ASYNC;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncSet.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setPacketInMaskEqualMaster(long packetInMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public long getPacketInMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskSlave not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setPacketInMaskSlave(long packetInMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskSlave not supported in version 1.5");
        }

        @Override
        public long getPortStatusMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setPortStatusMaskEqualMaster(long portStatusMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public long getPortStatusMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskSlave not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setPortStatusMaskSlave(long portStatusMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskSlave not supported in version 1.5");
        }

        @Override
        public long getFlowRemovedMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setFlowRemovedMaskEqualMaster(long flowRemovedMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public long getFlowRemovedMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskSlave not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setFlowRemovedMaskSlave(long flowRemovedMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskSlave not supported in version 1.5");
        }

        @Override
        public List<OFAsyncConfigProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFAsyncSet.Builder setProperties(List<OFAsyncConfigProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFAsyncSet build() {
            List<OFAsyncConfigProp> properties;
            long xid = this.xidSet ? this.xid : 0L;
            List<OFAsyncConfigProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFAsyncSetVer15(xid, properties);
        }
    }

    static class BuilderWithParent
    implements OFAsyncSet.Builder {
        final OFAsyncSetVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean propertiesSet;
        private List<OFAsyncConfigProp> properties;

        BuilderWithParent(OFAsyncSetVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.SET_ASYNC;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncSet.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setPacketInMaskEqualMaster(long packetInMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public long getPacketInMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskSlave not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setPacketInMaskSlave(long packetInMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskSlave not supported in version 1.5");
        }

        @Override
        public long getPortStatusMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setPortStatusMaskEqualMaster(long portStatusMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public long getPortStatusMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskSlave not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setPortStatusMaskSlave(long portStatusMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskSlave not supported in version 1.5");
        }

        @Override
        public long getFlowRemovedMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setFlowRemovedMaskEqualMaster(long flowRemovedMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskEqualMaster not supported in version 1.5");
        }

        @Override
        public long getFlowRemovedMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskSlave not supported in version 1.5");
        }

        @Override
        public OFAsyncSet.Builder setFlowRemovedMaskSlave(long flowRemovedMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskSlave not supported in version 1.5");
        }

        @Override
        public List<OFAsyncConfigProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFAsyncSet.Builder setProperties(List<OFAsyncConfigProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFAsyncSet build() {
            List properties;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFAsyncSetVer15(xid, properties);
        }
    }
}

