/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFPortStatsOpticalFlags;

public class OFPortStatsOpticalFlagsSerializerVer14 {
    public static final int RX_TUNE_VAL = 1;
    public static final int TX_TUNE_VAL = 2;
    public static final int TX_PWR_VAL = 4;
    public static final int RX_PWR_VAL = 16;
    public static final int TX_BIAS_VAL = 32;
    public static final int TX_TEMP_VAL = 64;

    public static Set<OFPortStatsOpticalFlags> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFPortStatsOpticalFlagsSerializerVer14.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFPortStatsOpticalFlags> set) {
        bb.writeInt(OFPortStatsOpticalFlagsSerializerVer14.toWireValue(set));
    }

    public static void putTo(Set<OFPortStatsOpticalFlags> set, PrimitiveSink sink) {
        sink.putInt(OFPortStatsOpticalFlagsSerializerVer14.toWireValue(set));
    }

    public static Set<OFPortStatsOpticalFlags> ofWireValue(int val) {
        EnumSet<OFPortStatsOpticalFlags> set = EnumSet.noneOf(OFPortStatsOpticalFlags.class);
        if ((val & 1) != 0) {
            set.add(OFPortStatsOpticalFlags.RX_TUNE);
        }
        if ((val & 2) != 0) {
            set.add(OFPortStatsOpticalFlags.TX_TUNE);
        }
        if ((val & 4) != 0) {
            set.add(OFPortStatsOpticalFlags.TX_PWR);
        }
        if ((val & 0x10) != 0) {
            set.add(OFPortStatsOpticalFlags.RX_PWR);
        }
        if ((val & 0x20) != 0) {
            set.add(OFPortStatsOpticalFlags.TX_BIAS);
        }
        if ((val & 0x40) != 0) {
            set.add(OFPortStatsOpticalFlags.TX_TEMP);
        }
        return Collections.unmodifiableSet(set);
    }

    public static int toWireValue(Set<OFPortStatsOpticalFlags> set) {
        int wireValue = 0;
        block8: for (OFPortStatsOpticalFlags e : set) {
            switch (e) {
                case RX_TUNE: {
                    wireValue |= 1;
                    continue block8;
                }
                case TX_TUNE: {
                    wireValue |= 2;
                    continue block8;
                }
                case TX_PWR: {
                    wireValue |= 4;
                    continue block8;
                }
                case RX_PWR: {
                    wireValue |= 0x10;
                    continue block8;
                }
                case TX_BIAS: {
                    wireValue |= 0x20;
                    continue block8;
                }
                case TX_TEMP: {
                    wireValue |= 0x40;
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFPortStatsOpticalFlags in version 1.4: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

