/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6NdTargetMasked;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmIpv6NdTargetVer14;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpv6NdTargetMaskedVer14
implements OFOxmIpv6NdTargetMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpv6NdTargetMaskedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 36;
    private static final IPv6Address DEFAULT_VALUE = IPv6Address.NONE;
    private static final IPv6Address DEFAULT_VALUE_MASK = IPv6Address.NONE;
    private final IPv6Address value;
    private final IPv6Address mask;
    static final OFOxmIpv6NdTargetMaskedVer14 DEFAULT = new OFOxmIpv6NdTargetMaskedVer14(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIpv6NdTargetMaskedVer14Funnel FUNNEL = new OFOxmIpv6NdTargetMaskedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpv6NdTargetMaskedVer14(IPv6Address value, IPv6Address mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpv6NdTargetMaskedVer14: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmIpv6NdTargetMaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147499808L;
    }

    @Override
    public IPv6Address getValue() {
        return this.value;
    }

    @Override
    public IPv6Address getMask() {
        return this.mask;
    }

    @Override
    public MatchField<IPv6Address> getMatchField() {
        return MatchField.IPV6_ND_TARGET;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<IPv6Address> getCanonical() {
        if (IPv6Address.NO_MASK.equals(this.mask)) {
            return new OFOxmIpv6NdTargetVer14(this.value);
        }
        if (IPv6Address.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmIpv6NdTargetMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpv6NdTargetMaskedVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpv6NdTargetMaskedVer14 other = (OFOxmIpv6NdTargetMaskedVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpv6NdTargetMaskedVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIpv6NdTargetMaskedVer14 message) {
            bb.writeInt(-2147467488);
            message.value.write16Bytes(bb);
            message.mask.write16Bytes(bb);
        }
    }

    static class OFOxmIpv6NdTargetMaskedVer14Funnel
    implements Funnel<OFOxmIpv6NdTargetMaskedVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmIpv6NdTargetMaskedVer14Funnel() {
        }

        public void funnel(OFOxmIpv6NdTargetMaskedVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147467488);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpv6NdTargetMasked> {
        Reader() {
        }

        @Override
        public OFOxmIpv6NdTargetMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147467488) {
                throw new OFParseError("Wrong typeLen: Expected=0x80003f20L(0x80003f20L), got=" + typeLen);
            }
            IPv6Address value = IPv6Address.read16Bytes(bb);
            IPv6Address mask = IPv6Address.read16Bytes(bb);
            OFOxmIpv6NdTargetMaskedVer14 oxmIpv6NdTargetMaskedVer14 = new OFOxmIpv6NdTargetMaskedVer14(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpv6NdTargetMaskedVer14);
            }
            return oxmIpv6NdTargetMaskedVer14;
        }
    }

    static class Builder
    implements OFOxmIpv6NdTargetMasked.Builder {
        private boolean valueSet;
        private IPv6Address value;
        private boolean maskSet;
        private IPv6Address mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147499808L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6NdTargetMasked.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv6Address getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpv6NdTargetMasked.Builder setMask(IPv6Address mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.IPV6_ND_TARGET;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpv6NdTargetMasked build() {
            IPv6Address mask;
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv6Address iPv6Address2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpv6NdTargetMaskedVer14(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpv6NdTargetMasked.Builder {
        final OFOxmIpv6NdTargetMaskedVer14 parentMessage;
        private boolean valueSet;
        private IPv6Address value;
        private boolean maskSet;
        private IPv6Address mask;

        BuilderWithParent(OFOxmIpv6NdTargetMaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147499808L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6NdTargetMasked.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv6Address getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpv6NdTargetMasked.Builder setMask(IPv6Address mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.IPV6_ND_TARGET;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpv6NdTargetMasked build() {
            IPv6Address mask;
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv6Address iPv6Address2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpv6NdTargetMaskedVer14(value, mask);
        }
    }
}

