/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingNwProto;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingNwProtoVer14
implements OFOxmConnTrackingNwProto {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingNwProtoVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmConnTrackingNwProtoVer14 DEFAULT = new OFOxmConnTrackingNwProtoVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingNwProtoVer14Funnel FUNNEL = new OFOxmConnTrackingNwProtoVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingNwProtoVer14(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingNwProtoVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 126465L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.CONN_TRACKING_NW_PROTO;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmConnTrackingNwProto.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingNwProtoVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingNwProtoVer14 other = (OFOxmConnTrackingNwProtoVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingNwProtoVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingNwProtoVer14 message) {
            bb.writeInt(126465);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmConnTrackingNwProtoVer14Funnel
    implements Funnel<OFOxmConnTrackingNwProtoVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingNwProtoVer14Funnel() {
        }

        public void funnel(OFOxmConnTrackingNwProtoVer14 message, PrimitiveSink sink) {
            sink.putInt(126465);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingNwProto> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingNwProto readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 126465) {
                throw new OFParseError("Wrong typeLen: Expected=0x1ee01L(0x1ee01L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmConnTrackingNwProtoVer14 oxmConnTrackingNwProtoVer14 = new OFOxmConnTrackingNwProtoVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingNwProtoVer14);
            }
            return oxmConnTrackingNwProtoVer14;
        }
    }

    static class Builder
    implements OFOxmConnTrackingNwProto.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 126465L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingNwProto.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.CONN_TRACKING_NW_PROTO;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmConnTrackingNwProto build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingNwProtoVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingNwProto.Builder {
        final OFOxmConnTrackingNwProtoVer14 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmConnTrackingNwProtoVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 126465L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingNwProto.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.CONN_TRACKING_NW_PROTO;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmConnTrackingNwProto build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingNwProtoVer14(value);
        }
    }
}

